/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.managers;

import javafx.event.EventHandler;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.stage.Window;
import us.ihmc.messager.Messager;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerTopics;

public class WindowShortcutManager {
    private final Window owner;
    private final EventHandler<KeyEvent> currentIndexSteppingListener;

    public WindowShortcutManager(Window owner, Messager messager, SessionVisualizerTopics topics) {
        this.owner = owner;
        this.currentIndexSteppingListener = keyEvent -> {
            int step;
            if (!keyEvent.isAltDown()) {
                return;
            }
            if (keyEvent.getCode() == KeyCode.LEFT || keyEvent.getCode() == KeyCode.KP_LEFT) {
                step = -1;
            } else if (keyEvent.getCode() == KeyCode.RIGHT || keyEvent.getCode() == KeyCode.KP_RIGHT) {
                step = 1;
            } else {
                return;
            }
            if (keyEvent.isShiftDown()) {
                step *= 10;
            }
            messager.submitMessage(topics.getYoBufferIncrementCurrentIndexRequest(), (Object)step);
            keyEvent.consume();
        };
        owner.setOnCloseRequest(e -> this.stop());
    }

    public void start() {
        this.owner.addEventHandler(KeyEvent.KEY_PRESSED, this.currentIndexSteppingListener);
    }

    public void stop() {
        this.owner.removeEventHandler(KeyEvent.KEY_PRESSED, this.currentIndexSteppingListener);
    }
}

