/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.managers;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;
import us.ihmc.scs2.session.Session;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.Manager;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.ObservedAnimationTimer;

public class ChartRenderManager
extends ObservedAnimationTimer
implements Manager {
    private final IntegerProperty numberOfLayersToRenderPerUpdate = new SimpleIntegerProperty((Object)this, "numberOfLayersToRenderPerUpdate", -1);
    private final Queue<Runnable> chartUpdaterToCall = new ConcurrentLinkedQueue<Runnable>();

    public void submitRenderRequest(Runnable chartUpdater) {
        if (!this.chartUpdaterToCall.contains(chartUpdater)) {
            this.chartUpdaterToCall.add(chartUpdater);
        }
    }

    public void clearRequests() {
        this.chartUpdaterToCall.clear();
    }

    @Override
    public void handleImpl(long now) {
        int numberOfLayers = this.numberOfLayersToRenderPerUpdate.get();
        numberOfLayers = numberOfLayers <= 0 ? this.chartUpdaterToCall.size() : Math.min(numberOfLayers, this.chartUpdaterToCall.size());
        for (int i = 0; i < numberOfLayers; ++i) {
            Runnable layer = this.chartUpdaterToCall.poll();
            if (layer == null) continue;
            layer.run();
        }
    }

    @Override
    public void startSession(Session session) {
        this.start();
    }

    @Override
    public void stopSession() {
        this.stop();
        this.clearRequests();
    }

    @Override
    public boolean isSessionLoaded() {
        return true;
    }
}

