/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.properties;

import java.lang.ref.WeakReference;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleDoubleProperty;
import org.apache.commons.lang3.mutable.MutableBoolean;
import us.ihmc.scs2.sessionVisualizer.jfx.properties.YoVariableProperty;
import us.ihmc.scs2.sharedMemory.LinkedYoDouble;
import us.ihmc.yoVariables.listener.YoVariableChangedListener;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoVariable;

public class YoDoubleProperty
extends DoublePropertyBase
implements YoVariableProperty<YoDouble, Number> {
    private final YoDouble yoDouble;
    private final Object bean;
    private final YoVariableChangedListener propertyUpdater = new YoDoublePropertyUpdater(this);
    private SimpleDoubleProperty lastUserInput;
    private LinkedYoDouble linkedBuffer;
    private Object userObject;

    public YoDoubleProperty(YoDouble yoDouble) {
        this(yoDouble, null);
    }

    public YoDoubleProperty(YoDouble yoDouble, Object bean) {
        this.yoDouble = yoDouble;
        this.bean = bean;
        this.pullYoDoubleValue();
        yoDouble.addListener(this.propertyUpdater);
    }

    public void setLinkedBuffer(LinkedYoDouble linkedBuffer) {
        if (this.linkedBuffer != null) {
            this.linkedBuffer.removeUser(this.userObject);
        }
        this.linkedBuffer = linkedBuffer;
        if (this.userObject == null) {
            this.userObject = new Object();
        }
        if (linkedBuffer != null) {
            linkedBuffer.addUser(this.userObject);
        }
    }

    public LinkedYoDouble getLinkedBuffer() {
        return this.linkedBuffer;
    }

    @Override
    public void finalize() {
        this.yoDouble.removeListener(this.propertyUpdater);
        if (this.linkedBuffer != null) {
            this.linkedBuffer.removeUser(this.userObject);
        }
    }

    public void set(double newValue) {
        if (this.lastUserInput != null) {
            this.lastUserInput.set(newValue);
        }
        super.set(newValue);
        this.yoDouble.set(newValue);
    }

    public void setAndPush(double newValue) {
        this.set(newValue);
        if (this.linkedBuffer != null) {
            this.linkedBuffer.push();
        }
    }

    private void pullYoDoubleValue() {
        super.set(this.yoDouble.getValue());
    }

    public void bindDoubleProperty(Property<Double> property) {
        property.setValue((Object)this.getValue());
        MutableBoolean updatingControl = new MutableBoolean(false);
        MutableBoolean updatingThis = new MutableBoolean(false);
        this.addListener((o, oldValue, newValue) -> {
            if (updatingThis.isTrue()) {
                return;
            }
            updatingControl.setTrue();
            property.setValue((Object)newValue.doubleValue());
            updatingControl.setFalse();
        });
        property.addListener((o, oldValue, newValue) -> {
            if (updatingControl.isTrue()) {
                return;
            }
            updatingThis.setTrue();
            this.setAndPush((double)newValue);
            updatingThis.setFalse();
        });
    }

    public DoubleProperty userInputProperty() {
        if (this.lastUserInput == null) {
            this.lastUserInput = new SimpleDoubleProperty((Object)this, this.getName() + "LastUserInput", this.get());
        }
        return this.lastUserInput;
    }

    @Override
    public YoDouble getYoVariable() {
        return this.yoDouble;
    }

    public Object getBean() {
        return this.bean;
    }

    public String getName() {
        return this.yoDouble.getName();
    }

    private static class YoDoublePropertyUpdater
    implements YoVariableChangedListener {
        private final WeakReference<YoDoubleProperty> propertyRef;

        public YoDoublePropertyUpdater(YoDoubleProperty property) {
            this.propertyRef = new WeakReference<YoDoubleProperty>(property);
        }

        public void changed(YoVariable source) {
            YoDoubleProperty property = (YoDoubleProperty)this.propertyRef.get();
            if (property != null) {
                property.pullYoDoubleValue();
            }
        }
    }
}

