/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.session.remote;

import java.util.function.Supplier;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.fxml.FXML;
import javafx.scene.control.Label;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Pane;
import us.ihmc.commons.Conversions;
import us.ihmc.scs2.sessionVisualizer.jfx.session.SessionInfoController;
import us.ihmc.scs2.sessionVisualizer.jfx.session.remote.LoggerStatusUpdater;
import us.ihmc.scs2.sessionVisualizer.jfx.session.remote.RemoteSession;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.ObservedAnimationTimer;

public class YoClientInformationPaneController
extends ObservedAnimationTimer
implements SessionInfoController {
    @FXML
    private AnchorPane mainPane;
    @FXML
    private Label delayLabel;
    @FXML
    private Label logDurationLabel;
    @FXML
    private Label cameraLabel;
    private final long refreshPeriod = Conversions.secondsToNanoseconds((double)0.1);
    private long lastRefreshTime = -1L;
    private Supplier<String> delayValueSupplier;
    private Supplier<String> logDurationValueSupplier;
    private Supplier<String> cameraValueSupplier;
    private final ObjectProperty<RemoteSession> activeSessionProperty = new SimpleObjectProperty((Object)this, "activeSession", null);

    public void initialize() {
        this.lastRefreshTime = -1L;
        this.delayValueSupplier = () -> {
            RemoteSession activeSession = (RemoteSession)((Object)((Object)this.activeSessionProperty.get()));
            if (activeSession == null) {
                return null;
            }
            return Conversions.nanosecondsToMilliseconds((long)activeSession.getDelay()) + "ms";
        };
        this.logDurationValueSupplier = () -> {
            RemoteSession activeSession = (RemoteSession)((Object)((Object)this.activeSessionProperty.get()));
            if (activeSession == null) {
                return null;
            }
            LoggerStatusUpdater loggerStatusUpdater = activeSession.getLoggerStatusUpdater();
            if (loggerStatusUpdater.isLogging()) {
                return loggerStatusUpdater.getCurrentLogDuration() + "sec";
            }
            return "Logger offline";
        };
        this.cameraValueSupplier = () -> {
            RemoteSession activeSession = (RemoteSession)((Object)((Object)this.activeSessionProperty.get()));
            if (activeSession == null) {
                return null;
            }
            LoggerStatusUpdater loggerStatusUpdater = activeSession.getLoggerStatusUpdater();
            return loggerStatusUpdater.isCameraRecording() ? "Recording" : "Off";
        };
    }

    public ObjectProperty<RemoteSession> activeSessionProperty() {
        return this.activeSessionProperty;
    }

    @Override
    public void handleImpl(long now) {
        if (this.lastRefreshTime != -1L && now - this.lastRefreshTime < this.refreshPeriod) {
            return;
        }
        this.updateLabel(this.delayLabel, this.delayValueSupplier, "N/D");
        this.updateLabel(this.logDurationLabel, this.logDurationValueSupplier, "N/D");
        this.updateLabel(this.cameraLabel, this.cameraValueSupplier, "N/D");
        this.lastRefreshTime = now;
    }

    @Override
    public Pane getMainPane() {
        return this.mainPane;
    }

    private void updateLabel(Label label, Supplier<String> textSupplier, String defaultText) {
        if (textSupplier == null) {
            label.setText(defaultText);
            return;
        }
        String text = textSupplier.get();
        if (text == null) {
            label.setText(defaultText);
            return;
        }
        label.setText(text);
    }
}

