/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.managers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.fxml.FXMLLoader;
import javafx.geometry.Rectangle2D;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import javafx.util.Pair;
import us.ihmc.javaFXToolkit.messager.JavaFXMessager;
import us.ihmc.log.LogTools;
import us.ihmc.scs2.definition.configuration.WindowConfigurationDefinition;
import us.ihmc.scs2.session.Session;
import us.ihmc.scs2.sessionVisualizer.jfx.SCSGuiConfiguration;
import us.ihmc.scs2.sessionVisualizer.jfx.SecondaryWindowController;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerIOTools;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerTopics;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.YoRegistryStatisticsPaneController;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.sliderboard.bcf2000.YoBCF2000SliderboardWindowController;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.yoComposite.pattern.YoCompositePatternPropertyWindowController;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.yoGraphic.YoGraphicPropertyWindowController;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.Manager;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.SessionVisualizerToolkit;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.JavaFXMissingTools;
import us.ihmc.yoVariables.registry.YoNamespace;
import us.ihmc.yoVariables.registry.YoRegistry;

public class SecondaryWindowManager
implements Manager {
    public static final String SECONDARY_CHART_WINDOW_TYPE = "SecondaryChartWindow";
    public static final String COMPOSITE_PATTERN_EDITOR_WINDOW_TYPE = "YoCompositeEditorWindow";
    public static final String GRAPHIC_EDITOR_WINDOW_TYPE = "YoGraphicEditorWindow";
    public static final String BCF2000_SLIDERBOARD_WINDOW_TYPE = "BC2000EditorWindow";
    public static final String REGISTRY_STATISTICS_WINDOW_TYPE = "YoRegistryStatisticsWindow";
    private final SessionVisualizerToolkit toolkit;
    private final Property<YoCompositePatternPropertyWindowController> yoCompositeEditor = new SimpleObjectProperty((Object)this, "yoCompositeEditor", null);
    private final Property<YoGraphicPropertyWindowController> yoGraphicEditor = new SimpleObjectProperty((Object)this, "yoGraphicEditor", null);
    private final Property<YoBCF2000SliderboardWindowController> bcf2000Sliderboard = new SimpleObjectProperty((Object)this, "bcf2000Sliderboard", null);
    private final Property<YoRegistryStatisticsPaneController> yoRegistryStatistics = new SimpleObjectProperty((Object)this, "yoRegistryStatistics", null);
    private final List<Stage> secondaryWindows = new ArrayList<Stage>();
    private final List<SecondaryWindowController> secondaryWindowControllers = new ArrayList<SecondaryWindowController>();
    private final JavaFXMessager messager;
    private final SessionVisualizerTopics topics;

    public SecondaryWindowManager(SessionVisualizerToolkit toolkit) {
        this.toolkit = toolkit;
        this.messager = toolkit.getMessager();
        this.topics = toolkit.getTopics();
        this.messager.registerTopicListener(this.topics.getOpenWindowRequest(), this::openWindow);
    }

    @Override
    public boolean isSessionLoaded() {
        return false;
    }

    @Override
    public void startSession(Session session) {
    }

    public void loadSessionConfiguration(SCSGuiConfiguration configuration) {
        JavaFXMissingTools.runAndWait(this.getClass(), () -> {
            if (configuration.hasSecondaryWindowConfigurations()) {
                List<WindowConfigurationDefinition> secondaryWindowConfigurations = configuration.getSecondaryWindowConfigurations();
                for (int i = 0; i < configuration.getNumberOfSecondaryYoChartGroupConfigurations(); ++i) {
                    WindowConfigurationDefinition secondaryWindowConfiguration = secondaryWindowConfigurations.get(i);
                    Stage stage = this.newChartWindow(secondaryWindowConfiguration);
                    this.messager.submitMessage(this.topics.getYoChartGroupLoadConfiguration(), (Object)new Pair((Object)stage, (Object)configuration.getSecondaryYoChartGroupConfigurationFile(i)));
                }
            }
        });
    }

    public void saveSessionConfiguration(SCSGuiConfiguration configuration) {
        if (this.bcf2000Sliderboard.getValue() != null) {
            ((YoBCF2000SliderboardWindowController)this.bcf2000Sliderboard.getValue()).save(configuration.getYoSliderboardConfigurationFile());
        }
        for (SecondaryWindowController secondaryWindow : this.secondaryWindowControllers) {
            secondaryWindow.saveSessionConfiguration(configuration);
        }
    }

    @Override
    public void stopSession() {
        if (this.yoCompositeEditor.getValue() != null) {
            ((YoCompositePatternPropertyWindowController)this.yoCompositeEditor.getValue()).closeAndDispose();
            this.yoCompositeEditor.setValue(null);
        }
        if (this.yoGraphicEditor.getValue() != null) {
            ((YoGraphicPropertyWindowController)this.yoGraphicEditor.getValue()).closeAndDispose();
            this.yoGraphicEditor.setValue(null);
        }
        if (this.bcf2000Sliderboard.getValue() != null) {
            ((YoBCF2000SliderboardWindowController)this.bcf2000Sliderboard.getValue()).close();
            this.bcf2000Sliderboard.setValue(null);
        }
        if (this.yoRegistryStatistics.getValue() != null) {
            ((YoRegistryStatisticsPaneController)this.yoRegistryStatistics.getValue()).close();
            this.yoRegistryStatistics.setValue(null);
        }
        this.secondaryWindows.forEach(secondaryWindow -> secondaryWindow.fireEvent((Event)new WindowEvent((Window)secondaryWindow, WindowEvent.WINDOW_CLOSE_REQUEST)));
        this.secondaryWindowControllers.forEach(SecondaryWindowController::closeAndDispose);
        this.secondaryWindowControllers.clear();
    }

    public void openWindow(Pair<String, Object> request) {
        if (request == null) {
            return;
        }
        String windowType = (String)request.getKey();
        if (windowType == null || windowType.isEmpty()) {
            return;
        }
        switch (windowType) {
            case "YoCompositeEditorWindow": {
                this.openYoCompositePatternEditor();
                break;
            }
            case "SecondaryChartWindow": {
                this.newChartWindow();
                break;
            }
            case "YoGraphicEditorWindow": {
                this.openYoGraphicEditor();
                break;
            }
            case "BC2000EditorWindow": {
                this.openBCF2000SliderboardWindow();
                return;
            }
            case "YoRegistryStatisticsWindow": {
                this.openRegistryStatisticsWindow((String)request.getValue());
            }
            default: {
                LogTools.error((String)("Unexpected value: " + windowType));
            }
        }
    }

    public void openYoCompositePatternEditor() {
        if (this.yoCompositeEditor.getValue() != null) {
            ((YoCompositePatternPropertyWindowController)this.yoCompositeEditor.getValue()).showWindow();
            return;
        }
        try {
            FXMLLoader fxmlLoader = new FXMLLoader(SessionVisualizerIOTools.YO_COMPOSITE_PATTERN_PROPERTY_WINDOW_URL);
            fxmlLoader.load();
            YoCompositePatternPropertyWindowController controller = (YoCompositePatternPropertyWindowController)fxmlLoader.getController();
            controller.initialize(this.toolkit);
            this.yoCompositeEditor.setValue((Object)controller);
            controller.showWindow();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Stage newChartWindow() {
        return this.newChartWindow(null);
    }

    public Stage newChartWindow(WindowConfigurationDefinition windowConfigurationDefinition) {
        Stage stage = this.newStage(windowConfigurationDefinition);
        try {
            FXMLLoader loader = new FXMLLoader(SessionVisualizerIOTools.SECONDARY_WINDOW_URL);
            loader.load();
            SecondaryWindowController controller = (SecondaryWindowController)loader.getController();
            controller.initialize(this.toolkit, stage);
            controller.setupChartGroup();
            this.secondaryWindowControllers.add(controller);
            stage.addEventHandler(WindowEvent.WINDOW_CLOSE_REQUEST, e -> {
                if (!e.isConsumed()) {
                    this.secondaryWindowControllers.remove(controller);
                }
            });
            controller.start();
            stage.show();
            return stage;
        }
        catch (IOException e2) {
            e2.printStackTrace();
            stage.close();
            return null;
        }
    }

    private Stage newStage(WindowConfigurationDefinition definition) {
        Stage stage = new Stage();
        if (definition != null) {
            double height;
            double width;
            double positionY;
            double positionX = definition.getPositionX();
            ObservableList screensForRectangle = Screen.getScreensForRectangle((double)positionX, (double)(positionY = definition.getPositionY()), (double)(width = definition.getWidth() > 0.0 ? definition.getWidth() : stage.getWidth()), (double)(height = definition.getHeight() > 0.0 ? definition.getHeight() : stage.getHeight()));
            if (screensForRectangle.isEmpty()) {
                Screen primary = Screen.getPrimary();
                Rectangle2D visualBounds = primary.getVisualBounds();
                width = Math.min(width, visualBounds.getWidth());
                height = Math.min(height, visualBounds.getHeight());
                positionX = 0.5 * (visualBounds.getMinX() + visualBounds.getMaxX() - width);
                positionY = 0.5 * (visualBounds.getMinY() + visualBounds.getMaxY() - height);
            }
            stage.setX(positionX);
            stage.setY(positionY);
            if (definition.isMaximized()) {
                stage.setMaximized(true);
            } else {
                stage.setWidth(width);
                stage.setHeight(height);
            }
        }
        this.secondaryWindows.add(stage);
        return stage;
    }

    public static WindowConfigurationDefinition toWindowConfigurationDefinition(Stage stage) {
        WindowConfigurationDefinition definition = new WindowConfigurationDefinition();
        if (stage.isMaximized()) {
            definition.setMaximized(true);
            definition.setPositionX(stage.getX());
            definition.setPositionY(stage.getY());
            definition.setWidth(stage.getWidth());
            definition.setHeight(stage.getHeight());
        } else {
            definition.setMaximized(false);
            definition.setPositionX(stage.getX());
            definition.setPositionY(stage.getY());
            definition.setWidth(stage.getWidth());
            definition.setHeight(stage.getHeight());
        }
        return definition;
    }

    private void openYoGraphicEditor() {
        if (this.yoGraphicEditor.getValue() != null) {
            ((YoGraphicPropertyWindowController)this.yoGraphicEditor.getValue()).showWindow();
            return;
        }
        try {
            FXMLLoader fxmlLoader = new FXMLLoader(SessionVisualizerIOTools.YO_GRAPHIC_PROPERTY_URL);
            fxmlLoader.load();
            YoGraphicPropertyWindowController controller = (YoGraphicPropertyWindowController)fxmlLoader.getController();
            controller.initialize(this.toolkit);
            this.yoGraphicEditor.setValue((Object)controller);
            controller.showWindow();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void openBCF2000SliderboardWindow() {
        if (this.bcf2000Sliderboard.getValue() != null) {
            ((YoBCF2000SliderboardWindowController)this.bcf2000Sliderboard.getValue()).showWindow();
            return;
        }
        try {
            FXMLLoader fxmlLoader = new FXMLLoader(SessionVisualizerIOTools.YO_SLIDERBOARD_BCF2000_WINDOW_URL);
            fxmlLoader.load();
            YoBCF2000SliderboardWindowController controller = (YoBCF2000SliderboardWindowController)fxmlLoader.getController();
            controller.initialize(this.toolkit);
            this.bcf2000Sliderboard.setValue((Object)controller);
            controller.showWindow();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void openRegistryStatisticsWindow(String registryFullname) {
        YoRegistry registry = this.toolkit.getYoManager().getRootRegistry().findRegistry(new YoNamespace(registryFullname));
        if (registry == null) {
            LogTools.error((String)"Could not find a registry from the name: {}", (Object)registryFullname);
            return;
        }
        if (this.yoRegistryStatistics.getValue() != null) {
            ((YoRegistryStatisticsPaneController)this.yoRegistryStatistics.getValue()).setInput(registry);
            ((YoRegistryStatisticsPaneController)this.yoRegistryStatistics.getValue()).showWindow();
        } else {
            try {
                FXMLLoader fxmlLoader = new FXMLLoader(SessionVisualizerIOTools.YO_REGISTRY_STATISTICS_URL);
                fxmlLoader.load();
                YoRegistryStatisticsPaneController controller = (YoRegistryStatisticsPaneController)fxmlLoader.getController();
                controller.initialize(this.toolkit);
                controller.setInput(registry);
                this.yoRegistryStatistics.setValue((Object)controller);
                controller.showWindow();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

