/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.controllers.chart;

import com.jfoenix.controls.JFXTextField;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import javafx.animation.AnimationTimer;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import us.ihmc.scs2.definition.yoChart.YoChartGroupModelDefinition;
import us.ihmc.scs2.definition.yoChart.YoChartIdentifierDefinition;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerIOTools;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.ControllerListCell;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.UIElement;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.chart.YoChartIdentifierEditorController;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.SessionVisualizerToolkit;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.ObservedAnimationTimer;

public class YoChartGroupModelEditorController
implements UIElement {
    @FXML
    private VBox mainPane;
    @FXML
    private Label configurationNameLabel;
    @FXML
    private JFXTextField configurationNameTextField;
    @FXML
    private Label configurationModelLabel;
    @FXML
    private ListView<YoChartIdentifierEditorController> listView;
    private final ObjectProperty<YoChartGroupModelDefinition> chartGroupModelProperty = new SimpleObjectProperty((Object)this, "chartGroupModel", null);
    private SessionVisualizerToolkit toolkit;
    private AnimationTimer prefHeightAdjustmentAnimation;

    public void initialize(SessionVisualizerToolkit toolkit) {
        this.toolkit = toolkit;
        this.listView.setCellFactory(param -> new ControllerListCell());
        this.listView.getItems().addListener(change -> {
            ObservableList newList = change.getList();
            YoChartGroupModelDefinition newModel = new YoChartGroupModelDefinition((YoChartGroupModelDefinition)this.chartGroupModelProperty.get());
            newModel.setChartIdentifiers(newList.stream().map(controller -> (YoChartIdentifierDefinition)controller.chartIdentifierProperty().get()).collect(Collectors.toList()));
            this.chartGroupModelProperty.set((Object)newModel);
            for (int i = 0; i < newList.size(); ++i) {
                int indexFinal = i;
                ((YoChartIdentifierEditorController)newList.get(i)).chartIdentifierProperty().addListener((o, oldValue, newValue) -> {
                    YoChartGroupModelDefinition updatedModel = new YoChartGroupModelDefinition((YoChartGroupModelDefinition)this.chartGroupModelProperty.get());
                    updatedModel.getChartIdentifiers().set(indexFinal, newValue);
                    this.chartGroupModelProperty.set((Object)updatedModel);
                });
            }
        });
        this.configurationNameTextField.textProperty().addListener((o, oldValue, newValue) -> {
            YoChartGroupModelDefinition newModel = new YoChartGroupModelDefinition((YoChartGroupModelDefinition)this.chartGroupModelProperty.get());
            newModel.setName(newValue);
            this.chartGroupModelProperty.set((Object)newModel);
        });
        this.setPrefHeight();
    }

    public void setInput(YoChartGroupModelDefinition input, List<? extends String> chartIdNames) {
        this.configurationNameTextField.setText(input.getName());
        ObservableList listItems = this.listView.getItems();
        while (listItems.size() < input.getChartIdentifiers().size()) {
            listItems.add((Object)this.newYoChartIdentifierEditor());
        }
        while (listItems.size() > input.getChartIdentifiers().size()) {
            YoChartIdentifierEditorController removedController = (YoChartIdentifierEditorController)listItems.remove(listItems.size() - 1);
            removedController.closeAndDispose();
        }
        for (int i = 0; i < listItems.size(); ++i) {
            ((YoChartIdentifierEditorController)listItems.get(i)).setInput((YoChartIdentifierDefinition)input.getChartIdentifiers().get(i));
        }
        if (chartIdNames != null) {
            this.setChartIdentifierNames(chartIdNames);
        }
    }

    public void setChartIdentifierNames(List<? extends String> chartIdNames) {
        ObservableList listItems = this.listView.getItems();
        if (chartIdNames.size() != listItems.size()) {
            throw new IllegalArgumentException("The chartIdNames has to have the same size as the number of chart identifiers.");
        }
        for (int i = 0; i < listItems.size(); ++i) {
            ((YoChartIdentifierEditorController)listItems.get(i)).getChartIdLabel().setText(chartIdNames.get(i));
        }
    }

    private void setPrefHeight() {
        if (this.prefHeightAdjustmentAnimation == null) {
            this.prefHeightAdjustmentAnimation = new ObservedAnimationTimer(this.getClass().getSimpleName()){

                @Override
                public void handleImpl(long now) {
                    if (YoChartGroupModelEditorController.this.listView.getItems().isEmpty()) {
                        YoChartGroupModelEditorController.this.listView.setMinHeight(0.0);
                        YoChartGroupModelEditorController.this.listView.setMaxHeight(0.0);
                        YoChartGroupModelEditorController.this.listView.setPrefHeight(0.0);
                    } else {
                        double minHeight = ((YoChartIdentifierEditorController)YoChartGroupModelEditorController.this.listView.getItems().get(0)).getMainPane().getHeight() + 10.0;
                        int size = YoChartGroupModelEditorController.this.listView.getItems().size();
                        YoChartGroupModelEditorController.this.listView.setMinHeight(minHeight);
                        YoChartGroupModelEditorController.this.listView.setPrefHeight((double)size * minHeight);
                        YoChartGroupModelEditorController.this.listView.setMaxHeight(2.0 * (double)size * minHeight);
                    }
                }
            };
        }
        this.prefHeightAdjustmentAnimation.start();
    }

    private YoChartIdentifierEditorController newYoChartIdentifierEditor() {
        FXMLLoader loader = new FXMLLoader(SessionVisualizerIOTools.CHART_IDENTIFIER_EDITOR_PANE_URL);
        try {
            loader.load();
            YoChartIdentifierEditorController editor = (YoChartIdentifierEditorController)loader.getController();
            editor.initialize(this.toolkit);
            return editor;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void startEditingChartGroupModelName() {
        this.configurationNameTextField.requestFocus();
    }

    public StringProperty configurationNameProperty() {
        return this.configurationNameTextField.textProperty();
    }

    public ReadOnlyObjectProperty<YoChartGroupModelDefinition> chartGroupModelProperty() {
        return this.chartGroupModelProperty;
    }

    public void closeAndDispose() {
        this.prefHeightAdjustmentAnimation.stop();
    }

    @Override
    public Pane getMainPane() {
        return this.mainPane;
    }
}

