/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.controllers.sliderboard.bcf2000;

import com.jfoenix.controls.JFXSpinner;
import com.jfoenix.controls.JFXTextField;
import javafx.fxml.FXML;
import javafx.scene.control.Label;
import javafx.scene.control.Labeled;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import us.ihmc.log.LogTools;
import us.ihmc.scs2.definition.yoSlider.YoKnobDefinition;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.sliderboard.YoVariableSlider;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.sliderboard.bcf2000.YoBCF2000InputController;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.SessionVisualizerToolkit;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.YoManager;
import us.ihmc.scs2.sessionVisualizer.sliderboard.SliderboardVariable;
import us.ihmc.yoVariables.variable.YoVariable;

public class YoBCF2000KnobController
extends YoBCF2000InputController {
    @FXML
    private VBox rootPane;
    @FXML
    private JFXTextField knobMaxTextField;
    @FXML
    private JFXTextField knobMinTextField;
    @FXML
    private JFXSpinner spinner;
    @FXML
    private Label yoVariableDropLabel;
    private SliderboardVariable sliderVariable;
    private YoVariableSlider yoVariableSlider;
    private YoManager yoManager;

    public void initialize(SessionVisualizerToolkit toolkit, SliderboardVariable sliderVariable) {
        this.sliderVariable = sliderVariable;
        this.yoManager = toolkit.getYoManager();
        super.initialize(toolkit, (Region)this.rootPane, (Labeled)this.yoVariableDropLabel);
        this.knobMaxTextField.setText("");
        this.knobMinTextField.setText("");
        this.knobMaxTextField.setDisable(true);
        this.knobMinTextField.setDisable(true);
        this.spinner.setDisable(true);
    }

    public void setInput(YoKnobDefinition definition) {
        YoVariable yoVariable;
        if (definition == null) {
            this.setYoVariableInput(null);
            return;
        }
        if (definition.getVariableName() != null) {
            yoVariable = this.yoManager.getRootRegistryDatabase().searchExact(definition.getVariableName());
            if (yoVariable == null) {
                LogTools.warn((String)("Could not find variable for slider: " + definition.getVariableName()));
            }
        } else {
            yoVariable = null;
        }
        this.setYoVariableInput(yoVariable, definition.getMinValue(), definition.getMaxValue());
    }

    @Override
    public void setYoVariableInput(YoVariable yoVariable) {
        this.setYoVariableInput(yoVariable, null, null);
    }

    private void setYoVariableInput(YoVariable yoVariable, String minValue, String maxValue) {
        if (this.yoVariableSlider != null) {
            this.yoVariableSlider.dispose();
        }
        if (yoVariable != null) {
            this.spinner.setDisable(false);
            this.yoVariableSlider = YoVariableSlider.newYoVariableSlider(yoVariable, this.yoManager.getLinkedRootRegistry());
            this.yoVariableSlider.bindMinTextField(this.knobMinTextField);
            this.yoVariableSlider.bindMaxTextField(this.knobMaxTextField);
            if (this.sliderVariable != null) {
                this.yoVariableSlider.bindSliderVariable(this.sliderVariable);
            }
            this.yoVariableSlider.bindVirtualKnob(this.spinner);
            if (minValue != null && !this.knobMinTextField.isDisabled()) {
                this.knobMinTextField.setText(minValue);
            }
            if (maxValue != null && !this.knobMaxTextField.isDisabled()) {
                this.knobMaxTextField.setText(maxValue);
            }
            this.setupYoVariableSlider(this.yoVariableSlider);
        } else {
            this.clear();
            this.spinner.setDisable(true);
            this.yoVariableSlider = null;
            this.knobMaxTextField.setText("");
            this.knobMinTextField.setText("");
        }
    }

    public void close() {
        if (this.yoVariableSlider != null) {
            this.setYoVariableInput(null);
        }
    }

    public YoKnobDefinition toYoKnobDefinition() {
        return this.yoVariableSlider == null ? new YoKnobDefinition() : this.yoVariableSlider.toYoKnobDefinition();
    }
}

