/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.camera;

import java.util.concurrent.TimeoutException;
import javafx.scene.PerspectiveCamera;
import javafx.scene.transform.Transform;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.testfx.api.FxToolkit;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.camera.PerspectiveCameraController;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.TranslateSCS2;

public class CameraControlTest {
    private static final double EPSILON = 1.0E-12;

    @Tag(value="javafx-headless")
    @Test
    public void testCameraControls() throws TimeoutException {
        if (!FxToolkit.isFXApplicationThreadRunning()) {
            FxToolkit.registerPrimaryStage();
        }
        PerspectiveCamera camera = new PerspectiveCamera();
        camera = new PerspectiveCamera(true);
        camera.setNearClip(0.05);
        camera.setFarClip(200000.0);
        PerspectiveCameraController controller = new PerspectiveCameraController(null, null, camera, (Vector3DReadOnly)Axis3D.Z, (Vector3DReadOnly)Axis3D.X);
        Point3D expectedFocalPoint = new Point3D();
        Point3D expectedCameraPosition = new Point3D(-1.0, 0.0, 0.0);
        controller.setFocalPoint((Point3DReadOnly)expectedFocalPoint, true);
        controller.setCameraPosition((Point3DReadOnly)expectedCameraPosition, false);
        Vector3D expectedCameraLookDirection = new Vector3D(1.0, 0.0, 0.0);
        Vector3D expectedCameraRightDirection = new Vector3D(0.0, -1.0, 0.0);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedFocalPoint, (EuclidGeometry)controller.getFocalPointTranslate(), (double)1.0E-12);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedCameraPosition, (EuclidGeometry)this.cameraPosition(camera), (double)1.0E-12);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedCameraLookDirection, (EuclidGeometry)CameraControlTest.cameraLookDirection(camera), (double)1.0E-12);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedCameraRightDirection, (EuclidGeometry)CameraControlTest.cameraRightDirection(camera), (double)1.0E-12);
        controller.setCameraPosition(Double.NaN, Double.NaN, Double.NaN, false);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedFocalPoint, (EuclidGeometry)controller.getFocalPointTranslate(), (double)1.0E-12);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedCameraPosition, (EuclidGeometry)this.cameraPosition(camera), (double)1.0E-12);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedCameraLookDirection, (EuclidGeometry)CameraControlTest.cameraLookDirection(camera), (double)1.0E-12);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedCameraRightDirection, (EuclidGeometry)CameraControlTest.cameraRightDirection(camera), (double)1.0E-12);
        expectedFocalPoint.add(0.0, 0.0, 1.0);
        controller.setFocalPoint((Point3DReadOnly)expectedFocalPoint, false);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedFocalPoint, (EuclidGeometry)controller.getFocalPointTranslate(), (double)1.0E-12);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedCameraPosition, (EuclidGeometry)this.cameraPosition(camera), (double)1.0E-12);
        expectedCameraLookDirection.sub((Tuple3DReadOnly)expectedFocalPoint, (Tuple3DReadOnly)expectedCameraPosition);
        expectedCameraLookDirection.normalize();
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedCameraLookDirection, (EuclidGeometry)CameraControlTest.cameraLookDirection(camera), (double)1.0E-12);
        expectedFocalPoint.add(0.0, 0.0, 1.0);
        expectedCameraRightDirection = CameraControlTest.cameraRightDirection(camera);
        expectedCameraPosition.add(0.0, 0.0, 1.0);
        controller.setCameraPosition((Point3DReadOnly)expectedCameraPosition, true);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedFocalPoint, (EuclidGeometry)controller.getFocalPointTranslate(), (double)1.0E-12);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedCameraPosition, (EuclidGeometry)this.cameraPosition(camera), (double)1.0E-12);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedCameraLookDirection, (EuclidGeometry)CameraControlTest.cameraLookDirection(camera), (double)1.0E-12);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedCameraRightDirection, (EuclidGeometry)CameraControlTest.cameraRightDirection(camera), (double)1.0E-12);
        expectedFocalPoint = new Point3D();
        expectedCameraPosition = new Point3D(-1.0, 0.0, 0.0);
        controller.setFocalPoint((Point3DReadOnly)expectedFocalPoint, true);
        controller.setCameraPosition((Point3DReadOnly)expectedCameraPosition, false);
        expectedCameraLookDirection = new Vector3D(1.0, 0.0, 0.0);
        expectedCameraRightDirection = new Vector3D(0.0, -1.0, 0.0);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedFocalPoint, (EuclidGeometry)controller.getFocalPointTranslate(), (double)1.0E-12);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedCameraPosition, (EuclidGeometry)this.cameraPosition(camera), (double)1.0E-12);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedCameraLookDirection, (EuclidGeometry)CameraControlTest.cameraLookDirection(camera), (double)1.0E-12);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedCameraRightDirection, (EuclidGeometry)CameraControlTest.cameraRightDirection(camera), (double)1.0E-12);
        expectedCameraPosition = new Point3D(-2.0, 0.0, 0.0);
        controller.setCameraOrbit(2.0, Double.NaN, Double.NaN, Double.NaN, false);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedFocalPoint, (EuclidGeometry)controller.getFocalPointTranslate(), (double)1.0E-12);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedCameraPosition, (EuclidGeometry)this.cameraPosition(camera), (double)1.0E-12);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedCameraLookDirection, (EuclidGeometry)CameraControlTest.cameraLookDirection(camera), (double)1.0E-12);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedCameraRightDirection, (EuclidGeometry)CameraControlTest.cameraRightDirection(camera), (double)1.0E-12);
    }

    public TranslateSCS2 cameraPosition(PerspectiveCamera camera) {
        return new TranslateSCS2(camera.getLocalToSceneTransform());
    }

    public static Vector3D cameraLookDirection(PerspectiveCamera camera) {
        Transform cameraTransform = camera.getLocalToSceneTransform();
        return new Vector3D(cameraTransform.getMxz(), cameraTransform.getMyz(), cameraTransform.getMzz());
    }

    public static Vector3D cameraRightDirection(PerspectiveCamera camera) {
        Transform cameraTransform = camera.getLocalToSceneTransform();
        return new Vector3D(cameraTransform.getMxx(), cameraTransform.getMyx(), cameraTransform.getMzx());
    }
}

