/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.session.mcap.specs.records;

import java.util.Objects;
import us.ihmc.scs2.session.mcap.encoding.MCAPCRC32Helper;
import us.ihmc.scs2.session.mcap.output.MCAPDataOutput;
import us.ihmc.scs2.session.mcap.specs.records.MCAPElement;
import us.ihmc.scs2.session.mcap.specs.records.Record;

public interface MetadataIndex
extends MCAPElement {
    @Override
    default public long getElementLength() {
        return 20 + this.name().length();
    }

    public Record metadata();

    public long metadataOffset();

    public long metadataLength();

    public String name();

    @Override
    default public void write(MCAPDataOutput dataOutput) {
        dataOutput.putLong(this.metadataOffset());
        dataOutput.putLong(this.metadataLength());
        dataOutput.putString(this.name());
    }

    @Override
    default public MCAPCRC32Helper updateCRC(MCAPCRC32Helper crc32) {
        if (crc32 == null) {
            crc32 = new MCAPCRC32Helper();
        }
        crc32.addLong(this.metadataOffset());
        crc32.addLong(this.metadataLength());
        crc32.addString(this.name());
        return crc32;
    }

    @Override
    default public String toString(int indent) {
        String out = this.getClass().getSimpleName() + ": ";
        out = out + "\n\t-metadataOffset = " + this.metadataOffset();
        out = out + "\n\t-metadataLength = " + this.metadataLength();
        out = out + "\n\t-name = " + this.name();
        return MCAPElement.indent(out, indent);
    }

    @Override
    default public boolean equals(MCAPElement mcapElement) {
        if (mcapElement == this) {
            return true;
        }
        if (mcapElement instanceof MetadataIndex) {
            MetadataIndex other = (MetadataIndex)mcapElement;
            if (this.metadataOffset() != other.metadataOffset()) {
                return false;
            }
            if (this.metadataLength() != other.metadataLength()) {
                return false;
            }
            if (!Objects.equals(this.name(), other.name())) {
                return false;
            }
            return Objects.equals(this.metadata(), other.metadata());
        }
        return false;
    }
}

