/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.session.mcap.specs.records;

import java.lang.ref.WeakReference;
import java.util.List;
import us.ihmc.scs2.session.mcap.input.MCAPDataInput;
import us.ihmc.scs2.session.mcap.specs.MCAP;
import us.ihmc.scs2.session.mcap.specs.records.ChunkIndex;
import us.ihmc.scs2.session.mcap.specs.records.Compression;
import us.ihmc.scs2.session.mcap.specs.records.MessageIndexOffset;
import us.ihmc.scs2.session.mcap.specs.records.Record;
import us.ihmc.scs2.session.mcap.specs.records.RecordDataInputBacked;

public class ChunkIndexDataInputBacked
implements ChunkIndex {
    private final MCAPDataInput dataInput;
    private final long elementLength;
    private final long messageStartTime;
    private final long messageEndTime;
    private final long chunkOffset;
    private final long chunkLength;
    private final long messageIndexOffsetsOffset;
    private final long messageIndexOffsetsLength;
    private WeakReference<List<MessageIndexOffset>> messageIndexOffsetsRef;
    private final long messageIndexLength;
    private final Compression compression;
    private final long recordsCompressedLength;
    private final long recordsUncompressedLength;
    private WeakReference<Record> chunkRef;

    ChunkIndexDataInputBacked(MCAPDataInput dataInput, long elementPosition, long elementLength) {
        this.dataInput = dataInput;
        this.elementLength = elementLength;
        dataInput.position(elementPosition);
        this.messageStartTime = MCAP.checkPositiveLong(dataInput.getLong(), "messageStartTime");
        this.messageEndTime = MCAP.checkPositiveLong(dataInput.getLong(), "messageEndTime");
        this.chunkOffset = MCAP.checkPositiveLong(dataInput.getLong(), "chunkOffset");
        this.chunkLength = MCAP.checkPositiveLong(dataInput.getLong(), "chunkLength");
        this.messageIndexOffsetsLength = dataInput.getUnsignedInt();
        this.messageIndexOffsetsOffset = dataInput.position();
        dataInput.skip(this.messageIndexOffsetsLength);
        this.messageIndexLength = MCAP.checkPositiveLong(dataInput.getLong(), "messageIndexLength");
        this.compression = Compression.fromString(dataInput.getString());
        this.recordsCompressedLength = MCAP.checkPositiveLong(dataInput.getLong(), "compressedSize");
        this.recordsUncompressedLength = MCAP.checkPositiveLong(dataInput.getLong(), "uncompressedSize");
    }

    @Override
    public long getElementLength() {
        return this.elementLength;
    }

    @Override
    public Record chunk() {
        Record chunk;
        Record record = chunk = this.chunkRef == null ? null : (Record)this.chunkRef.get();
        if (chunk == null) {
            chunk = new RecordDataInputBacked(this.dataInput, this.chunkOffset);
            this.chunkRef = new WeakReference<Record>(chunk);
        }
        return (Record)this.chunkRef.get();
    }

    @Override
    public long messageStartTime() {
        return this.messageStartTime;
    }

    @Override
    public long messageEndTime() {
        return this.messageEndTime;
    }

    @Override
    public long chunkOffset() {
        return this.chunkOffset;
    }

    @Override
    public long chunkLength() {
        return this.chunkLength;
    }

    @Override
    public long messageIndexOffsetsLength() {
        return this.messageIndexOffsetsLength;
    }

    @Override
    public List<MessageIndexOffset> messageIndexOffsets() {
        List<MessageIndexOffset> messageIndexOffsets;
        List<MessageIndexOffset> list = messageIndexOffsets = this.messageIndexOffsetsRef == null ? null : (List<MessageIndexOffset>)this.messageIndexOffsetsRef.get();
        if (messageIndexOffsets == null) {
            messageIndexOffsets = MCAP.parseList(this.dataInput, MessageIndexOffset::new, this.messageIndexOffsetsOffset, this.messageIndexOffsetsLength);
            this.messageIndexOffsetsRef = new WeakReference<List<MessageIndexOffset>>(messageIndexOffsets);
        }
        return messageIndexOffsets;
    }

    @Override
    public long messageIndexLength() {
        return this.messageIndexLength;
    }

    @Override
    public Compression compression() {
        return this.compression;
    }

    @Override
    public long recordsCompressedLength() {
        return this.recordsCompressedLength;
    }

    @Override
    public long recordsUncompressedLength() {
        return this.recordsUncompressedLength;
    }

    public String toString() {
        return this.toString(0);
    }

    public boolean equals(Object object) {
        ChunkIndex other;
        return object instanceof ChunkIndex && ChunkIndex.super.equals(other = (ChunkIndex)object);
    }
}

