/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.session.mcap.specs.records;

import java.lang.ref.WeakReference;
import java.util.List;
import us.ihmc.scs2.session.mcap.input.MCAPDataInput;
import us.ihmc.scs2.session.mcap.specs.MCAP;
import us.ihmc.scs2.session.mcap.specs.records.Channel;
import us.ihmc.scs2.session.mcap.specs.records.StringPair;

class ChannelDataInputBacked
implements Channel {
    private final MCAPDataInput dataInput;
    private final long elementLength;
    private final int id;
    private final int schemaId;
    private final String topic;
    private final String messageEncoding;
    private WeakReference<List<StringPair>> metadataRef;
    private final long metadataOffset;
    private final long metadataLength;

    public ChannelDataInputBacked(MCAPDataInput dataInput, long elementPosition, long elementLength) {
        this.dataInput = dataInput;
        this.elementLength = elementLength;
        dataInput.position(elementPosition);
        this.id = dataInput.getUnsignedShort();
        this.schemaId = dataInput.getUnsignedShort();
        this.topic = dataInput.getString();
        this.messageEncoding = dataInput.getString();
        this.metadataLength = dataInput.getUnsignedInt();
        this.metadataOffset = dataInput.position();
    }

    @Override
    public long getElementLength() {
        return this.elementLength;
    }

    @Override
    public int id() {
        return this.id;
    }

    @Override
    public int schemaId() {
        return this.schemaId;
    }

    @Override
    public String topic() {
        return this.topic;
    }

    @Override
    public String messageEncoding() {
        return this.messageEncoding;
    }

    @Override
    public List<StringPair> metadata() {
        List<StringPair> metadata;
        List<StringPair> list = metadata = this.metadataRef == null ? null : (List<StringPair>)this.metadataRef.get();
        if (metadata == null) {
            metadata = MCAP.parseList(this.dataInput, StringPair::new, this.metadataOffset, this.metadataLength);
            this.metadataRef = new WeakReference<List<StringPair>>(metadata);
        }
        return metadata;
    }

    public String toString() {
        return this.toString(0);
    }

    public boolean equals(Object object) {
        Channel other;
        return object instanceof Channel && Channel.super.equals(other = (Channel)object);
    }
}

