/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.session.mcap.specs;

import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;
import us.ihmc.log.LogTools;
import us.ihmc.scs2.session.mcap.input.MCAPDataInput;
import us.ihmc.scs2.session.mcap.specs.records.Footer;
import us.ihmc.scs2.session.mcap.specs.records.MCAPElement;
import us.ihmc.scs2.session.mcap.specs.records.Magic;
import us.ihmc.scs2.session.mcap.specs.records.Opcode;
import us.ihmc.scs2.session.mcap.specs.records.Record;
import us.ihmc.scs2.session.mcap.specs.records.RecordDataInputBacked;

public class MCAP {
    protected MCAPDataInput dataInput;
    private final List<Record> records;
    private Record footer;

    public MCAP(FileChannel fileChannel) {
        this.dataInput = MCAPDataInput.wrap(fileChannel);
        long currentPos = 0L;
        Magic.readMagic(this.dataInput, currentPos);
        currentPos += Magic.getElementLength();
        this.records = new ArrayList<Record>();
        try {
            RecordDataInputBacked lastRecord;
            do {
                if ((lastRecord = new RecordDataInputBacked(this.dataInput, currentPos)).getElementLength() < 0L) {
                    throw new IllegalArgumentException("Invalid record length: " + lastRecord.getElementLength());
                }
                currentPos += lastRecord.getElementLength();
                this.records.add(lastRecord);
            } while (lastRecord.op() != Opcode.FOOTER);
        }
        catch (IllegalArgumentException e) {
            try {
                LogTools.info((String)"Loaded records:\n");
                for (Record record : this.records) {
                    System.out.println(record);
                }
            }
            catch (Exception e2) {
                throw e;
            }
            throw e;
        }
        Magic.readMagic(this.dataInput, currentPos);
    }

    public MCAPDataInput getDataInput() {
        return this.dataInput;
    }

    public List<Record> records() {
        return this.records;
    }

    public Record footer() {
        if (this.footer == null) {
            this.footer = new RecordDataInputBacked(this.dataInput, Footer.computeOffsetFooter(this.dataInput));
        }
        return this.footer;
    }

    public static <T extends MCAPElement> List<T> parseList(MCAPDataInput dataInput, MCAPDataReader<T> elementParser) {
        return MCAP.parseList(dataInput, elementParser, dataInput.getUnsignedInt());
    }

    public static <T extends MCAPElement> List<T> parseList(MCAPDataInput dataInput, MCAPDataReader<T> elementParser, long length) {
        return MCAP.parseList(dataInput, elementParser, dataInput.position(), length);
    }

    public static <T extends MCAPElement> List<T> parseList(MCAPDataInput dataInput, MCAPDataReader<T> elementParser, long offset, long length) {
        return MCAP.parseList(dataInput, elementParser, offset, length, null);
    }

    public static <T extends MCAPElement> List<T> parseList(MCAPDataInput dataInput, MCAPDataReader<T> elementParser, long offset, long length, List<T> listToPack) {
        long position = offset;
        long limit = position + length;
        if (listToPack == null) {
            listToPack = new ArrayList<T>();
        }
        while (position < limit) {
            T parsed = elementParser.parse(dataInput, position);
            listToPack.add(parsed);
            position += parsed.getElementLength();
        }
        return listToPack;
    }

    public static long checkPositiveLong(long value, String name) {
        if (value < 0L) {
            throw new IllegalArgumentException(name + " must be positive. Value: " + value);
        }
        return value;
    }

    public static void checkLength(long expectedLength, long actualLength) {
        if (actualLength != expectedLength) {
            throw new IllegalArgumentException("Unexpected length: expected= " + expectedLength + ", actual= " + actualLength);
        }
    }

    public static interface MCAPDataReader<T extends MCAPElement> {
        public T parse(MCAPDataInput var1, long var2);
    }
}

