/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.session.mcap.specs.records;

import java.lang.ref.WeakReference;
import us.ihmc.scs2.session.mcap.input.MCAPDataInput;
import us.ihmc.scs2.session.mcap.specs.MCAP;
import us.ihmc.scs2.session.mcap.specs.records.AttachmentIndex;
import us.ihmc.scs2.session.mcap.specs.records.Record;
import us.ihmc.scs2.session.mcap.specs.records.RecordDataInputBacked;

class AttachmentIndexDataInputBacked
implements AttachmentIndex {
    private final MCAPDataInput dataInput;
    private final long attachmentOffset;
    private final long attachmentLength;
    private final long logTime;
    private final long createTime;
    private final long dataLength;
    private final String name;
    private final String mediaType;
    private WeakReference<Record> attachmentRef;

    AttachmentIndexDataInputBacked(MCAPDataInput dataInput, long elementPosition, long elementLength) {
        this.dataInput = dataInput;
        dataInput.position(elementPosition);
        this.attachmentOffset = MCAP.checkPositiveLong(dataInput.getLong(), "attachmentOffset");
        this.attachmentLength = MCAP.checkPositiveLong(dataInput.getLong(), "attachmentLength");
        this.logTime = MCAP.checkPositiveLong(dataInput.getLong(), "logTime");
        this.createTime = MCAP.checkPositiveLong(dataInput.getLong(), "createTime");
        this.dataLength = MCAP.checkPositiveLong(dataInput.getLong(), "dataSize");
        this.name = dataInput.getString();
        this.mediaType = dataInput.getString();
        MCAP.checkLength(elementLength, this.getElementLength());
    }

    @Override
    public Record attachment() {
        Record attachment;
        Record record = attachment = this.attachmentRef == null ? null : (Record)this.attachmentRef.get();
        if (attachment == null) {
            attachment = new RecordDataInputBacked(this.dataInput, this.attachmentOffset);
            this.attachmentRef = new WeakReference<Record>(attachment);
        }
        return attachment;
    }

    @Override
    public long attachmentOffset() {
        return this.attachmentOffset;
    }

    @Override
    public long attachmentLength() {
        return this.attachmentLength;
    }

    @Override
    public long logTime() {
        return this.logTime;
    }

    @Override
    public long createTime() {
        return this.createTime;
    }

    @Override
    public long dataLength() {
        return this.dataLength;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String mediaType() {
        return this.mediaType;
    }

    public String toString() {
        return this.toString(0);
    }

    public boolean equals(Object object) {
        AttachmentIndex other;
        return object instanceof AttachmentIndex && AttachmentIndex.super.equals(other = (AttachmentIndex)object);
    }
}

