/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.session.mcap.specs.records;

import java.lang.ref.WeakReference;
import us.ihmc.scs2.session.mcap.encoding.MCAPCRC32Helper;
import us.ihmc.scs2.session.mcap.input.MCAPDataInput;
import us.ihmc.scs2.session.mcap.output.MCAPDataOutput;
import us.ihmc.scs2.session.mcap.specs.MCAP;
import us.ihmc.scs2.session.mcap.specs.records.Attachment;
import us.ihmc.scs2.session.mcap.specs.records.AttachmentIndex;
import us.ihmc.scs2.session.mcap.specs.records.Channel;
import us.ihmc.scs2.session.mcap.specs.records.Chunk;
import us.ihmc.scs2.session.mcap.specs.records.ChunkIndex;
import us.ihmc.scs2.session.mcap.specs.records.DataEnd;
import us.ihmc.scs2.session.mcap.specs.records.Footer;
import us.ihmc.scs2.session.mcap.specs.records.Header;
import us.ihmc.scs2.session.mcap.specs.records.MCAPElement;
import us.ihmc.scs2.session.mcap.specs.records.Message;
import us.ihmc.scs2.session.mcap.specs.records.MessageIndexDataInputBacked;
import us.ihmc.scs2.session.mcap.specs.records.Metadata;
import us.ihmc.scs2.session.mcap.specs.records.MetadataIndexDataInputBacked;
import us.ihmc.scs2.session.mcap.specs.records.Opcode;
import us.ihmc.scs2.session.mcap.specs.records.Record;
import us.ihmc.scs2.session.mcap.specs.records.Schema;
import us.ihmc.scs2.session.mcap.specs.records.Statistics;
import us.ihmc.scs2.session.mcap.specs.records.SummaryOffset;

public class RecordDataInputBacked
implements Record {
    private final MCAPDataInput dataInput;
    private final Opcode op;
    private final long bodyLength;
    private final long bodyOffset;
    private WeakReference<Object> bodyRef;

    public RecordDataInputBacked(MCAPDataInput dataInput, long elementPosition) {
        this.dataInput = dataInput;
        dataInput.position(elementPosition);
        this.op = Opcode.byId(dataInput.getUnsignedByte());
        this.bodyLength = MCAP.checkPositiveLong(dataInput.getLong(), "bodyLength");
        this.bodyOffset = dataInput.position();
        MCAP.checkLength(this.getElementLength(), (int)(this.bodyLength + 9L));
    }

    @Override
    public void write(MCAPDataOutput dataOutput, boolean writeBody) {
        dataOutput.putUnsignedByte(this.op.id());
        dataOutput.putLong(this.bodyLength);
        if (writeBody) {
            dataOutput.putBytes(this.dataInput.getBytes(this.bodyOffset, (int)this.bodyLength));
        }
    }

    @Override
    public MCAPCRC32Helper updateCRC(MCAPCRC32Helper crc32) {
        if (crc32 == null) {
            crc32 = new MCAPCRC32Helper();
        }
        crc32.addUnsignedByte(this.op.id());
        crc32.addLong(this.bodyLength);
        crc32.addBytes(this.dataInput.getBytes(this.bodyOffset, (int)this.bodyLength));
        return crc32;
    }

    @Override
    public Opcode op() {
        return this.op;
    }

    @Override
    public long bodyLength() {
        return this.bodyLength;
    }

    @Override
    public <T> T body() {
        Object body;
        byte[] byArray = body = this.bodyRef == null ? null : (byte[])this.bodyRef.get();
        if (body == null) {
            if (this.op == null) {
                body = this.dataInput.getBytes(this.bodyOffset, (int)this.bodyLength);
            } else {
                body = switch (this.op) {
                    default -> throw new IncompatibleClassChangeError();
                    case Opcode.MESSAGE -> Message.load(this.dataInput, this.bodyOffset, this.bodyLength);
                    case Opcode.METADATA_INDEX -> new MetadataIndexDataInputBacked(this.dataInput, this.bodyOffset, this.bodyLength);
                    case Opcode.CHUNK -> Chunk.load(this.dataInput, this.bodyOffset, this.bodyLength);
                    case Opcode.SCHEMA -> Schema.load(this.dataInput, this.bodyOffset, this.bodyLength);
                    case Opcode.CHUNK_INDEX -> ChunkIndex.load(this.dataInput, this.bodyOffset, this.bodyLength);
                    case Opcode.DATA_END -> new DataEnd(this.dataInput, this.bodyOffset, this.bodyLength);
                    case Opcode.ATTACHMENT_INDEX -> AttachmentIndex.load(this.dataInput, this.bodyOffset, this.bodyLength);
                    case Opcode.STATISTICS -> Statistics.load(this.dataInput, this.bodyOffset, this.bodyLength);
                    case Opcode.MESSAGE_INDEX -> new MessageIndexDataInputBacked(this.dataInput, this.bodyOffset, this.bodyLength);
                    case Opcode.CHANNEL -> Channel.load(this.dataInput, this.bodyOffset, this.bodyLength);
                    case Opcode.METADATA -> new Metadata(this.dataInput, this.bodyOffset, this.bodyLength);
                    case Opcode.ATTACHMENT -> Attachment.load(this.dataInput, this.bodyOffset, this.bodyLength);
                    case Opcode.HEADER -> new Header(this.dataInput, this.bodyOffset, this.bodyLength);
                    case Opcode.FOOTER -> new Footer(this.dataInput, this.bodyOffset, this.bodyLength);
                    case Opcode.SUMMARY_OFFSET -> new SummaryOffset(this.dataInput, this.bodyOffset, this.bodyLength);
                };
            }
            this.bodyRef = new WeakReference<byte[]>((byte[])body);
        }
        return (T)body;
    }

    @Override
    public long getElementLength() {
        return 9L + this.bodyLength;
    }

    public String toString() {
        return this.toString(0);
    }

    @Override
    public String toString(int indent) {
        String out = this.getClass().getSimpleName() + ":";
        out = out + "\n\t-op = " + this.op();
        out = out + "\n\t-bodyLength = " + this.bodyLength;
        out = out + "\n\t-bodyOffset = " + this.bodyOffset;
        Object body = this.body();
        out = out + "\n\t-body = " + (String)(body == null ? "null" : "\n" + ((MCAPElement)body).toString(indent + 2));
        return MCAPElement.indent(out, indent);
    }

    public boolean equals(Object object) {
        Record other;
        return object instanceof Record && Record.super.equals(other = (Record)object);
    }
}

