/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.session.mcap.specs.records;

import java.util.ArrayList;
import java.util.List;
import us.ihmc.scs2.session.mcap.specs.records.MessageIndex;
import us.ihmc.scs2.session.mcap.specs.records.MessageIndexEntry;

public class MutableMessageIndex
implements MessageIndex {
    private int channelId;
    private List<MessageIndexEntry> messageIndexEntries;
    private long messageIndexEntriesLength = 0L;

    public void setChannelId(int channelId) {
        this.channelId = channelId;
    }

    public void setMessageIndexEntries(List<MessageIndexEntry> messageIndexEntries) {
        this.messageIndexEntries = messageIndexEntries;
        this.messageIndexEntriesLength = messageIndexEntries.stream().mapToLong(MessageIndexEntry::getElementLength).sum();
    }

    public void addMessageIndexEntry(MessageIndexEntry messageIndexEntry) {
        if (this.messageIndexEntries == null) {
            this.messageIndexEntries = new ArrayList<MessageIndexEntry>();
        }
        this.messageIndexEntries.add(messageIndexEntry);
        this.messageIndexEntriesLength += messageIndexEntry.getElementLength();
    }

    public long messageIndexEntriesLength() {
        return this.messageIndexEntriesLength;
    }

    @Override
    public long getElementLength() {
        return 6L + this.messageIndexEntriesLength;
    }

    @Override
    public int channelId() {
        return this.channelId;
    }

    @Override
    public List<MessageIndexEntry> messageIndexEntries() {
        return this.messageIndexEntries;
    }

    public String toString() {
        return this.toString(0);
    }

    public boolean equals(Object object) {
        MessageIndex other;
        return object instanceof MessageIndex && MessageIndex.super.equals(other = (MessageIndex)object);
    }
}

