/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.session.mcap.specs.records;

import java.util.Collection;
import us.ihmc.scs2.session.mcap.encoding.MCAPCRC32Helper;
import us.ihmc.scs2.session.mcap.input.MCAPDataInput;
import us.ihmc.scs2.session.mcap.output.MCAPDataOutput;
import us.ihmc.scs2.session.mcap.specs.MCAP;
import us.ihmc.scs2.session.mcap.specs.records.MCAPElement;
import us.ihmc.scs2.session.mcap.specs.records.Opcode;
import us.ihmc.scs2.session.mcap.specs.records.Record;
import us.ihmc.scs2.session.mcap.specs.records.Records;

public class Footer
implements MCAPElement {
    public static final int ELEMENT_LENGTH = 20;
    private final MCAPDataInput dataInput;
    private final long summarySectionOffset;
    private final long summaryOffsetSectionOffset;
    private final long summaryCRC32;
    private Records summarySection;
    private Records summaryOffsetSection;
    private byte[] summaryCRC32Input;

    public Footer(MCAPDataInput dataInput, long elementPosition, long elementLength) {
        this.dataInput = dataInput;
        dataInput.position(elementPosition);
        this.summarySectionOffset = MCAP.checkPositiveLong(dataInput.getLong(), "summarySectionOffset");
        this.summaryOffsetSectionOffset = MCAP.checkPositiveLong(dataInput.getLong(), "summaryOffsetSectionOffset");
        this.summaryCRC32 = dataInput.getUnsignedInt();
        MCAP.checkLength(elementLength, this.getElementLength());
    }

    public Footer(long summarySectionOffset, Collection<? extends Record> summaryRecords, Collection<? extends Record> summaryOffsetRecords) {
        this.summarySection = new Records(summaryRecords);
        this.summaryOffsetSection = new Records(summaryOffsetRecords);
        this.summarySectionOffset = summarySectionOffset;
        this.summaryOffsetSectionOffset = summarySectionOffset + this.summarySection.getElementLength();
        MCAPCRC32Helper crc32 = new MCAPCRC32Helper();
        this.summarySection.forEach(record -> record.updateCRC(crc32));
        this.summaryOffsetSection.forEach(record -> record.updateCRC(crc32));
        crc32.addUnsignedByte(Opcode.FOOTER.id());
        crc32.addLong(20L);
        crc32.addLong(summarySectionOffset);
        crc32.addLong(this.summaryOffsetSectionOffset);
        this.summaryCRC32 = crc32.getValue();
        this.dataInput = null;
    }

    public static long computeOffsetFooter(MCAPDataInput dataInput) {
        return dataInput.size() - 9L - 20L - 8L;
    }

    @Override
    public long getElementLength() {
        return 20L;
    }

    public Records summarySection() {
        if (this.summarySection == null && this.summarySectionOffset != 0L) {
            this.summarySection = Records.load(this.dataInput, this.summarySectionOffset, this.summarySectionLength());
        }
        return this.summarySection;
    }

    public long summarySectionLength() {
        long summarySectionEnd = this.summaryOffsetSectionOffset != 0L ? this.summaryOffsetSectionOffset : Footer.computeOffsetFooter(this.dataInput);
        return summarySectionEnd - this.summarySectionOffset;
    }

    public Records summaryOffsetSection() {
        if (this.summaryOffsetSection == null && this.summaryOffsetSectionOffset != 0L) {
            this.summaryOffsetSection = Records.load(this.dataInput, this.summaryOffsetSectionOffset, this.summaryOffsetSectionLength());
        }
        return this.summaryOffsetSection;
    }

    public long summaryOffsetSectionLength() {
        return Footer.computeOffsetFooter(this.dataInput) - this.summaryOffsetSectionOffset;
    }

    public byte[] summaryCRC32Input() {
        if (this.summaryCRC32Input == null) {
            long offset = this.summaryCRC32StartOffset();
            long length = this.dataInput.size() - offset - 8L - 4L;
            this.summaryCRC32Input = this.dataInput.getBytes(offset, (int)length);
        }
        return this.summaryCRC32Input;
    }

    public long summaryCRC32StartOffset() {
        return this.summarySectionOffset != 0L ? this.summarySectionOffset : Footer.computeOffsetFooter(this.dataInput);
    }

    public long summarySectionOffset() {
        return this.summarySectionOffset;
    }

    public long summaryOffsetSectionOffset() {
        return this.summaryOffsetSectionOffset;
    }

    public long summaryCRC32() {
        return this.summaryCRC32;
    }

    @Override
    public void write(MCAPDataOutput dataOutput) {
        dataOutput.putLong(this.summarySectionOffset());
        dataOutput.putLong(this.summaryOffsetSectionOffset());
        dataOutput.putUnsignedInt(this.summaryCRC32());
    }

    @Override
    public MCAPCRC32Helper updateCRC(MCAPCRC32Helper crc32) {
        if (crc32 == null) {
            crc32 = new MCAPCRC32Helper();
        }
        crc32.addLong(this.summarySectionOffset());
        crc32.addLong(this.summaryOffsetSectionOffset());
        crc32.addUnsignedInt(this.summaryCRC32());
        return crc32;
    }

    public String toString() {
        return this.toString(0);
    }

    @Override
    public String toString(int indent) {
        String out = this.getClass().getSimpleName() + ":";
        out = out + "\n\t-ofsSummarySection = " + this.summarySectionOffset();
        out = out + "\n\t-ofsSummaryOffsetSection = " + this.summaryOffsetSectionOffset();
        out = out + "\n\t-summaryCrc32 = " + this.summaryCRC32();
        return MCAPElement.indent(out, indent);
    }

    public boolean equals(Object object) {
        Footer other;
        return object instanceof Footer && this.equals(other = (Footer)object);
    }

    @Override
    public boolean equals(MCAPElement mcapElement) {
        if (mcapElement == this) {
            return true;
        }
        if (mcapElement instanceof Footer) {
            Footer other = (Footer)mcapElement;
            if (this.summarySectionOffset() != other.summarySectionOffset()) {
                return false;
            }
            if (this.summaryOffsetSectionOffset() != other.summaryOffsetSectionOffset()) {
                return false;
            }
            return this.summaryCRC32() == other.summaryCRC32();
        }
        return false;
    }
}

