/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.session.mcap.specs.records;

import us.ihmc.scs2.session.mcap.encoding.MCAPCRC32Helper;
import us.ihmc.scs2.session.mcap.input.MCAPDataInput;
import us.ihmc.scs2.session.mcap.output.MCAPDataOutput;
import us.ihmc.scs2.session.mcap.specs.MCAP;
import us.ihmc.scs2.session.mcap.specs.records.MCAPElement;

public class DataEnd
implements MCAPElement {
    private final long dataSectionCRC32;

    public DataEnd(MCAPDataInput dataInput, long elementPosition, long elementLength) {
        dataInput.position(elementPosition);
        this.dataSectionCRC32 = dataInput.getUnsignedInt();
        MCAP.checkLength(elementLength, this.getElementLength());
    }

    public DataEnd(long dataSectionCRC32) {
        this.dataSectionCRC32 = dataSectionCRC32;
    }

    @Override
    public long getElementLength() {
        return 4L;
    }

    public long dataSectionCRC32() {
        return this.dataSectionCRC32;
    }

    @Override
    public void write(MCAPDataOutput dataOutput) {
        dataOutput.putUnsignedInt(this.dataSectionCRC32);
    }

    @Override
    public MCAPCRC32Helper updateCRC(MCAPCRC32Helper crc32) {
        if (crc32 == null) {
            crc32 = new MCAPCRC32Helper();
        }
        crc32.addUnsignedInt(this.dataSectionCRC32);
        return crc32;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ":\n\t-dataSectionCrc32 = " + this.dataSectionCRC32;
    }

    public boolean equals(Object object) {
        DataEnd other;
        return object instanceof DataEnd && this.equals(other = (DataEnd)object);
    }

    @Override
    public boolean equals(MCAPElement mcapElement) {
        if (mcapElement == this) {
            return true;
        }
        if (mcapElement instanceof DataEnd) {
            DataEnd other = (DataEnd)mcapElement;
            return this.dataSectionCRC32() == other.dataSectionCRC32();
        }
        return false;
    }
}

