/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.session.mcap.specs.records;

public enum Compression {
    NONE(""),
    LZ4("lz4"),
    ZSTD("zstd");

    private final String name;
    private final int length;

    private Compression(String name) {
        this.name = name;
        this.length = name.getBytes().length + 4;
    }

    public int getLength() {
        return this.length;
    }

    public String getName() {
        return this.name;
    }

    public static Compression fromString(String name) {
        return switch (name.trim().toLowerCase()) {
            case "" -> NONE;
            case "lz4" -> LZ4;
            case "zstd" -> ZSTD;
            default -> throw new IllegalArgumentException("Unsupported compression: " + name);
        };
    }
}

