/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.session.mcap;

import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import us.ihmc.scs2.session.mcap.output.MCAPDataOutput;
import us.ihmc.scs2.session.mcap.specs.MCAP;
import us.ihmc.scs2.session.mcap.specs.records.Attachment;
import us.ihmc.scs2.session.mcap.specs.records.Chunk;
import us.ihmc.scs2.session.mcap.specs.records.DataEnd;
import us.ihmc.scs2.session.mcap.specs.records.MCAPSummaryBuilder;
import us.ihmc.scs2.session.mcap.specs.records.Magic;
import us.ihmc.scs2.session.mcap.specs.records.MutableRecord;
import us.ihmc.scs2.session.mcap.specs.records.Record;

public class MCAPLogCropper {
    private final MCAP mcap;
    private long startTimestamp;
    private long endTimestamp;
    private OutputFormat outputFormat;

    public MCAPLogCropper(MCAP mcap) {
        this.mcap = mcap;
    }

    public void setStartTimestamp(long startTimestamp) {
        this.startTimestamp = startTimestamp;
    }

    public void setEndTimestamp(long endTimestamp) {
        this.endTimestamp = endTimestamp;
    }

    public void setOutputFormat(OutputFormat outputFormat) {
        this.outputFormat = outputFormat;
    }

    public void crop(FileOutputStream outputStream) throws IOException {
        MCAPDataOutput dataOutput = MCAPDataOutput.wrap(outputStream.getChannel());
        dataOutput.putBytes(Magic.MAGIC_BYTES);
        ArrayList<Record> recordsForNextChunk = null;
        MCAPSummaryBuilder summaryBuilder = new MCAPSummaryBuilder();
        for (Record record : this.mcap.records()) {
            switch (record.op()) {
                case CHUNK_INDEX: 
                case MESSAGE_INDEX: 
                case ATTACHMENT_INDEX: 
                case METADATA_INDEX: 
                case FOOTER: {
                    break;
                }
                case HEADER: {
                    record.write(dataOutput);
                    break;
                }
                case DATA_END: {
                    new MutableRecord(new DataEnd(0L)).write(dataOutput);
                    summaryBuilder.writeSummary(dataOutput);
                    break;
                }
                case SCHEMA: 
                case CHANNEL: {
                    summaryBuilder.update(record);
                    break;
                }
                case CHUNK: {
                    Chunk chunk = (Chunk)record.body();
                    if (chunk.messageStartTime() > this.endTimestamp) break;
                    long chunkOffset = dataOutput.position();
                    Chunk croppedChunk = chunk.crop(this.startTimestamp, this.endTimestamp);
                    if (croppedChunk == null) break;
                    MutableRecord croppedChunkRecord = new MutableRecord(croppedChunk);
                    if (!croppedChunk.records().containsMessages()) {
                        if (recordsForNextChunk != null) {
                            recordsForNextChunk.addAll(croppedChunk.records());
                            break;
                        }
                        recordsForNextChunk = new ArrayList<Record>(croppedChunk.records());
                        break;
                    }
                    if (recordsForNextChunk != null) {
                        croppedChunk.records().addAll(0, (Collection<? extends Record>)recordsForNextChunk);
                        recordsForNextChunk = null;
                    }
                    List<MutableRecord> croppedMessageIndexRecords = croppedChunk.records().generateMessageIndexList().stream().map(MutableRecord::new).toList();
                    summaryBuilder.update(croppedChunkRecord);
                    summaryBuilder.update(croppedChunkRecord.generateChunkIndexRecord(chunkOffset, croppedMessageIndexRecords));
                    croppedChunkRecord.write(dataOutput, true);
                    croppedMessageIndexRecords.forEach(r -> r.write(dataOutput, true));
                    break;
                }
                case ATTACHMENT: {
                    Attachment attachment = (Attachment)record.body();
                    if (attachment.logTime() < this.startTimestamp || attachment.logTime() > this.endTimestamp) break;
                    long attachmentOffset = dataOutput.position();
                    record.write(dataOutput, true);
                    summaryBuilder.update(record);
                    summaryBuilder.update(record.generateAttachmentIndexRecord(attachmentOffset));
                    break;
                }
                case METADATA: {
                    long metadataOffset = dataOutput.position();
                    record.write(dataOutput, true);
                    summaryBuilder.update(record);
                    summaryBuilder.update(record.generateMetadataIndexRecord(metadataOffset));
                    break;
                }
            }
        }
        dataOutput.putBytes(Magic.MAGIC_BYTES);
        dataOutput.close();
    }

    public static enum OutputFormat {
        MCAP;

    }
}

