/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.session.mcap.specs.records;

import java.util.List;
import java.util.Objects;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.scs2.session.mcap.encoding.MCAPCRC32Helper;
import us.ihmc.scs2.session.mcap.input.MCAPDataInput;
import us.ihmc.scs2.session.mcap.output.MCAPDataOutput;
import us.ihmc.scs2.session.mcap.specs.records.ChannelMessageCount;
import us.ihmc.scs2.session.mcap.specs.records.MCAPElement;
import us.ihmc.scs2.session.mcap.specs.records.StatisticsDataInputBacked;

public interface Statistics
extends MCAPElement {
    public static Statistics load(MCAPDataInput dataInput, long elementPosition, long elementLength) {
        return new StatisticsDataInputBacked(dataInput, elementPosition, elementLength);
    }

    public long messageCount();

    public int schemaCount();

    public long channelCount();

    public long attachmentCount();

    public long metadataCount();

    public long chunkCount();

    public long messageStartTime();

    public long messageEndTime();

    public List<ChannelMessageCount> channelMessageCounts();

    @Override
    default public void write(MCAPDataOutput dataOutput) {
        dataOutput.putLong(this.messageCount());
        dataOutput.putUnsignedShort(this.schemaCount());
        dataOutput.putUnsignedInt(this.channelCount());
        dataOutput.putUnsignedInt(this.attachmentCount());
        dataOutput.putUnsignedInt(this.metadataCount());
        dataOutput.putUnsignedInt(this.chunkCount());
        dataOutput.putLong(this.messageStartTime());
        dataOutput.putLong(this.messageEndTime());
        dataOutput.putCollection(this.channelMessageCounts());
    }

    @Override
    default public MCAPCRC32Helper updateCRC(MCAPCRC32Helper crc32) {
        if (crc32 == null) {
            crc32 = new MCAPCRC32Helper();
        }
        crc32.addLong(this.messageCount());
        crc32.addUnsignedShort(this.schemaCount());
        crc32.addUnsignedInt(this.channelCount());
        crc32.addUnsignedInt(this.attachmentCount());
        crc32.addUnsignedInt(this.metadataCount());
        crc32.addUnsignedInt(this.chunkCount());
        crc32.addLong(this.messageStartTime());
        crc32.addLong(this.messageEndTime());
        crc32.addCollection(this.channelMessageCounts());
        return crc32;
    }

    @Override
    default public String toString(int indent) {
        String out = this.getClass().getSimpleName() + ": ";
        out = out + "\n\t-messageCount = " + this.messageCount();
        out = out + "\n\t-schemaCount = " + this.schemaCount();
        out = out + "\n\t-channelCount = " + this.channelCount();
        out = out + "\n\t-attachmentCount = " + this.attachmentCount();
        out = out + "\n\t-metadataCount = " + this.metadataCount();
        out = out + "\n\t-chunkCount = " + this.chunkCount();
        out = out + "\n\t-messageStartTime = " + this.messageStartTime();
        out = out + "\n\t-messageEndTime = " + this.messageEndTime();
        out = out + "\n\t-channelMessageCounts = \n" + EuclidCoreIOTools.getCollectionString((String)"\n", this.channelMessageCounts(), e -> e.toString(1));
        return out;
    }

    @Override
    default public boolean equals(MCAPElement mcapElement) {
        if (mcapElement == this) {
            return true;
        }
        if (mcapElement instanceof Statistics) {
            Statistics other = (Statistics)mcapElement;
            if (this.messageCount() != other.messageCount()) {
                return false;
            }
            if (this.schemaCount() != other.schemaCount()) {
                return false;
            }
            if (this.channelCount() != other.channelCount()) {
                return false;
            }
            if (this.attachmentCount() != other.attachmentCount()) {
                return false;
            }
            if (this.metadataCount() != other.metadataCount()) {
                return false;
            }
            if (this.chunkCount() != other.chunkCount()) {
                return false;
            }
            if (this.messageStartTime() != other.messageStartTime()) {
                return false;
            }
            if (this.messageEndTime() != other.messageEndTime()) {
                return false;
            }
            return Objects.equals(this.channelMessageCounts(), other.channelMessageCounts());
        }
        return false;
    }
}

