/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.session.mcap.specs.records;

import java.util.Objects;
import us.ihmc.scs2.session.mcap.encoding.MCAPCRC32Helper;
import us.ihmc.scs2.session.mcap.input.MCAPDataInput;
import us.ihmc.scs2.session.mcap.output.MCAPDataOutput;
import us.ihmc.scs2.session.mcap.specs.records.MCAPElement;

public class StringPair
implements MCAPElement {
    private final String key;
    private final String value;

    public StringPair(MCAPDataInput dataInput, long elementPosition) {
        dataInput.position(elementPosition);
        this.key = dataInput.getString();
        this.value = dataInput.getString();
    }

    public StringPair(String key, String value) {
        this.key = key;
        this.value = value;
    }

    @Override
    public long getElementLength() {
        return this.key.length() + this.value.length() + 8;
    }

    public String key() {
        return this.key;
    }

    public String value() {
        return this.value;
    }

    @Override
    public void write(MCAPDataOutput dataOutput) {
        dataOutput.putString(this.key);
        dataOutput.putString(this.value);
    }

    @Override
    public MCAPCRC32Helper updateCRC(MCAPCRC32Helper crc32) {
        if (crc32 == null) {
            crc32 = new MCAPCRC32Helper();
        }
        crc32.addString(this.key);
        crc32.addString(this.value);
        return crc32;
    }

    public String toString() {
        return (this.key + ": " + this.value).replace("\n", "");
    }

    public boolean equals(Object object) {
        StringPair other;
        return object instanceof StringPair && this.equals(other = (StringPair)object);
    }

    @Override
    public boolean equals(MCAPElement mcapElement) {
        if (mcapElement == this) {
            return true;
        }
        if (mcapElement instanceof StringPair) {
            StringPair other = (StringPair)mcapElement;
            if (!Objects.equals(this.key(), other.key())) {
                return false;
            }
            return Objects.equals(this.value(), other.value());
        }
        return false;
    }
}

