/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.session.mcap.output;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import us.ihmc.scs2.session.mcap.output.MCAPDataOutput;

public class MCAPBufferedFileChannelOutput
implements MCAPDataOutput {
    static final int DEFAULT_BUFFER_SIZE = 8192;
    public static final boolean DEFAULT_USE_DIRECT_BUFFER = false;
    private final ByteBuffer writingBuffer;
    private final FileChannel fileChannel;

    public MCAPBufferedFileChannelOutput(FileChannel fileChannel) {
        this(fileChannel, 8192, false);
    }

    public MCAPBufferedFileChannelOutput(FileChannel fileChannel, int writingBufferSize, boolean useDirectBuffer) {
        this.fileChannel = fileChannel;
        this.writingBuffer = useDirectBuffer ? ByteBuffer.allocateDirect(writingBufferSize) : ByteBuffer.allocate(writingBufferSize);
        this.writingBuffer.order(ByteOrder.LITTLE_ENDIAN);
    }

    @Override
    public long position() {
        try {
            return this.fileChannel.position() + (long)this.writingBuffer.position();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void putLong(long value) {
        if (this.writingBuffer.remaining() < 8) {
            this.flush();
        }
        this.writingBuffer.putLong(value);
    }

    @Override
    public void putInt(int value) {
        if (this.writingBuffer.remaining() < 4) {
            this.flush();
        }
        this.writingBuffer.putInt(value);
    }

    @Override
    public void putShort(short value) {
        if (this.writingBuffer.remaining() < 2) {
            this.flush();
        }
        this.writingBuffer.putShort(value);
    }

    @Override
    public void putByte(byte value) {
        if (this.writingBuffer.remaining() < 1) {
            this.flush();
        }
        this.writingBuffer.put(value);
    }

    @Override
    public void putBytes(byte[] bytes, int offset, int length) {
        if (this.writingBuffer.remaining() >= length) {
            this.writingBuffer.put(bytes, offset, length);
            return;
        }
        try {
            this.flush();
            this.fileChannel.write(ByteBuffer.wrap(bytes, offset, length));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void putByteBuffer(ByteBuffer byteBuffer) {
        if (this.writingBuffer.remaining() >= byteBuffer.remaining()) {
            this.writingBuffer.put(byteBuffer);
            return;
        }
        try {
            this.flush();
            this.fileChannel.write(byteBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void flush() {
        this.writingBuffer.flip();
        try {
            this.fileChannel.write(this.writingBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.writingBuffer.clear();
    }

    @Override
    public void close() {
        this.flush();
        try {
            this.fileChannel.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return "MCAPBufferedFileChannelOutput [fileChannel=" + this.fileChannel + "]";
    }
}

