/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.session.mcap.input;

import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import us.ihmc.scs2.session.mcap.input.MCAPBufferedFileChannelInput;
import us.ihmc.scs2.session.mcap.input.MCAPByteBufferDataInput;

public interface MCAPDataInput {
    public void position(long var1);

    public long position();

    default public void skip(long length) {
        this.position(this.position() + length);
    }

    public long size();

    public long getLong();

    public int getInt();

    default public long getUnsignedInt() {
        return Integer.toUnsignedLong(this.getInt());
    }

    public short getShort();

    default public int getUnsignedShort() {
        return Short.toUnsignedInt(this.getShort());
    }

    public byte getByte();

    default public int getUnsignedByte() {
        return Byte.toUnsignedInt(this.getByte());
    }

    public void getBytes(byte[] var1);

    default public byte[] getBytes(int length) {
        byte[] bytes = new byte[length];
        this.getBytes(bytes);
        return bytes;
    }

    public byte[] getBytes(long var1, int var3);

    default public String getString() {
        return new String(this.getBytes((int)this.getUnsignedInt()));
    }

    public ByteBuffer getByteBuffer(long var1, int var3, boolean var4);

    public ByteBuffer getDecompressedByteBuffer(long var1, int var3, int var4, Compression var5, boolean var6);

    public static MCAPDataInput wrap(FileChannel fileChannel) {
        return new MCAPBufferedFileChannelInput(fileChannel);
    }

    public static MCAPDataInput wrap(ByteBuffer buffer) {
        return new MCAPByteBufferDataInput(buffer);
    }

    public static enum Compression {
        NONE,
        LZ4,
        ZSTD;


        public static Compression fromString(String name) {
            return switch (name.trim().toLowerCase()) {
                case "none", "" -> NONE;
                case "lz4" -> LZ4;
                case "zstd" -> ZSTD;
                default -> throw new IllegalArgumentException("Unsupported compression: " + name);
            };
        }
    }
}

