/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.session.mcap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.scs2.session.mcap.CDRDeserializer;
import us.ihmc.scs2.session.mcap.MCAP;

public class MCAPSchema {
    private final int id;
    private final String name;
    private final boolean isEnum;
    private final String[] enumConstants;
    private final List<MCAPSchemaField> staticFields = new ArrayList<MCAPSchemaField>();
    private final List<MCAPSchemaField> fields;
    private final Map<String, MCAPSchema> subSchemaMap;

    protected MCAPSchema(String name, int id) {
        this(name, id, new ArrayList<MCAPSchemaField>(), null);
    }

    protected MCAPSchema(String name, int id, List<MCAPSchemaField> fields) {
        this(name, id, fields, null);
    }

    protected MCAPSchema(String name, int id, List<MCAPSchemaField> fields, Map<String, MCAPSchema> subSchemaMap) {
        this.name = name;
        this.id = id;
        this.subSchemaMap = subSchemaMap;
        this.fields = fields;
        this.isEnum = false;
        this.enumConstants = null;
    }

    protected MCAPSchema(String name, int id, String[] enumConstants) {
        this.name = name;
        this.id = id;
        this.subSchemaMap = null;
        this.fields = null;
        this.isEnum = true;
        this.enumConstants = enumConstants;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public boolean isEnum() {
        return this.isEnum;
    }

    public String[] getEnumConstants() {
        return this.enumConstants;
    }

    public List<MCAPSchemaField> getFields() {
        return this.fields;
    }

    public Map<String, MCAPSchema> getSubSchemaMap() {
        return this.subSchemaMap;
    }

    public boolean isSchemaFlat() {
        return this.subSchemaMap == null || this.subSchemaMap.isEmpty();
    }

    public List<MCAPSchemaField> getStaticFields() {
        return this.staticFields;
    }

    public MCAPSchema flattenSchema() {
        ArrayList<MCAPSchemaField> flattenedFields = new ArrayList<MCAPSchemaField>();
        for (MCAPSchemaField field : this.fields) {
            flattenedFields.addAll(this.flattenField(field));
        }
        MCAPSchema mcapSchema = new MCAPSchema(this.name, this.id, flattenedFields, null);
        mcapSchema.getStaticFields().addAll(this.staticFields);
        return mcapSchema;
    }

    List<MCAPSchemaField> flattenField(MCAPSchemaField field) {
        ArrayList<MCAPSchemaField> flatFields;
        block4: {
            MCAPSchemaField flatField;
            block3: {
                flatField = field.clone();
                if (!field.isComplexType()) {
                    return Collections.singletonList(flatField);
                }
                flatFields = new ArrayList<MCAPSchemaField>();
                flatFields.add(flatField);
                if (!flatField.isArray()) break block3;
                for (int i = 0; i < flatField.getMaxLength(); ++i) {
                    MCAPSchemaField subField = new MCAPSchemaField();
                    subField.setParent(flatField);
                    subField.setType(flatField.getType());
                    subField.setName(flatField.getName() + "[" + i + "]");
                    subField.setArray(false);
                    subField.setVector(false);
                    subField.setMaxLength(-1);
                    flatFields.add(subField);
                }
                break block4;
            }
            MCAPSchema subSchema = this.subSchemaMap.get(flatField.getType());
            if (subSchema == null) break block4;
            for (MCAPSchemaField subField : subSchema.fields) {
                subField.setParent(flatField);
                subField.setName(flatField.getName() + "." + subField.getName());
                flatFields.add(subField);
            }
        }
        return flatFields;
    }

    public String toString() {
        return this.toString(0);
    }

    public String toString(int indent) {
        String out = this.getClass().getSimpleName() + ":";
        out = out + "\n\t-name=" + this.name;
        if (this.fields != null) {
            out = out + "\n\t-fields=\n" + EuclidCoreIOTools.getCollectionString((String)"\n", this.fields, f -> f.toString(indent + 2));
        }
        if (this.enumConstants != null) {
            out = out + "\n\t-enumConstants=" + Arrays.toString(this.enumConstants);
        }
        if (!this.staticFields.isEmpty()) {
            out = out + "\n\t-staticFields=\n" + EuclidCoreIOTools.getCollectionString((String)"\n", this.staticFields, f -> f.toString(indent + 2));
        }
        if (this.subSchemaMap != null) {
            out = out + "\n\t-subSchemaMap=\n" + MCAPSchema.indentString(indent + 2) + EuclidCoreIOTools.getCollectionString((String)("\n" + MCAPSchema.indentString(indent + 2)), this.subSchemaMap.entrySet(), e -> (String)e.getKey() + "->\n" + ((MCAPSchema)e.getValue()).toString(indent + 3).replace("^(\t*)", ""));
        }
        return MCAPSchema.indent(out, indent);
    }

    public static String mcapMCAPMessageToString(MCAP.Message message, MCAPSchema schema) {
        CDRDeserializer cdr = new CDRDeserializer();
        cdr.initialize(message.messageBuffer(), message.offsetData(), message.lengthData());
        String output = MCAPSchema.mcapMCAPMessageToString(cdr, schema, 0);
        cdr.finalize(true);
        return output;
    }

    private static String mcapMCAPMessageToString(CDRDeserializer cdr, MCAPSchema schema, int indent) {
        StringBuilder out = new StringBuilder(schema.getName() + ":");
        for (MCAPSchemaField field : schema.getFields()) {
            String fieldToString = MCAPSchema.mcapMCAPMessageFieldToString(cdr, field, schema, indent + 1);
            if (fieldToString == null) continue;
            out.append(fieldToString);
        }
        return out.toString();
    }

    private static String mcapMCAPMessageFieldToString(CDRDeserializer cdr, MCAPSchemaField field, MCAPSchema schema, int indent) {
        if (schema == null && field.isComplexType()) {
            return null;
        }
        StringBuilder out = new StringBuilder("\n" + MCAPSchema.indentString(indent) + field.getName() + ": ");
        if (field.isArray()) {
            out.append("[");
            for (int i = 0; i < field.getMaxLength(); ++i) {
                out.append("\n").append(MCAPSchema.indentString(indent + 1)).append(i).append(": ");
                out.append(MCAPSchema.mcapMCAPMessageFieldToString(cdr, field, schema, indent + 2));
            }
            out.append("\n").append(MCAPSchema.indentString(indent)).append("]");
        } else {
            Object fieldValue = null;
            try {
                fieldValue = cdr.readTypeAsString(CDRDeserializer.Type.parseType(field.getType()), field.getMaxLength());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (fieldValue == null) {
                MCAPSchema subSchema;
                MCAPSchema mCAPSchema = subSchema = schema.getSubSchemaMap() == null ? null : schema.getSubSchemaMap().get(field.getType());
                if (subSchema != null) {
                    fieldValue = "\n" + MCAPSchema.indentString(indent + 1) + MCAPSchema.mcapMCAPMessageToString(cdr, subSchema, indent + 1);
                } else if (!schema.isSchemaFlat()) {
                    fieldValue = "Unknown type: " + field.getType();
                }
            }
            out.append((String)fieldValue);
        }
        return out.toString();
    }

    public static String indent(String stringToIndent, int indent) {
        if (indent <= 0) {
            return stringToIndent;
        }
        String indentStr = MCAPSchema.indentString(indent);
        return indentStr + stringToIndent.replace("\n", "\n" + indentStr);
    }

    public static String indentString(int indent) {
        return "\t".repeat(indent);
    }

    public static final class MCAPSchemaField {
        private MCAPSchemaField parent;
        private String name;
        private String type;
        private boolean isArray;
        private boolean isVector;
        private int maxLength;
        private boolean isComplexType;
        private String defaultValue;

        public MCAPSchemaField() {
        }

        public MCAPSchemaField(String name, String type, boolean isArray, boolean isVector, int maxLength, boolean isComplexType) {
            this.name = name;
            this.type = type;
            this.isArray = isArray;
            this.isVector = isVector;
            this.maxLength = maxLength;
            this.isComplexType = isComplexType;
        }

        public MCAPSchemaField(MCAPSchemaField other) {
            this.name = other.name;
            this.type = other.type;
            this.isArray = other.isArray;
            this.isVector = other.isVector;
            this.maxLength = other.maxLength;
            this.isComplexType = other.isComplexType;
        }

        public MCAPSchemaField clone() {
            return new MCAPSchemaField(this);
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setType(String type) {
            this.type = type;
        }

        public void setParent(MCAPSchemaField parent) {
            this.parent = parent;
        }

        public void setArray(boolean array) {
            this.isArray = array;
        }

        public void setVector(boolean vector) {
            this.isVector = vector;
        }

        public void setMaxLength(int maxLength) {
            this.maxLength = maxLength;
        }

        public void setComplexType(boolean complexType) {
            this.isComplexType = complexType;
        }

        public void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public MCAPSchemaField getParent() {
            return this.parent;
        }

        public boolean isArray() {
            return this.isArray;
        }

        public boolean isVector() {
            return this.isVector;
        }

        public int getMaxLength() {
            return this.maxLength;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public boolean isComplexType() {
            return this.isComplexType;
        }

        public String toString() {
            return this.toString(0);
        }

        public String toString(int indent) {
            String out = this.getClass().getSimpleName() + ":";
            out = out + "\n\t-type=" + this.type;
            out = out + "\n\t-name=" + this.name;
            out = out + "\n\t-isArray=" + this.isArray;
            out = out + "\n\t-isVector=" + this.isVector;
            out = out + "\n\t-isComplexType=" + this.isComplexType;
            if (this.isArray || this.isVector) {
                out = out + "\n\t-maxLength=" + this.maxLength;
            }
            out = out + "\n\t-parent=" + (this.parent == null ? "null" : this.parent.name);
            out = out + "\n";
            return MCAPSchema.indent(out, indent);
        }
    }
}

