/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.session.mcap;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBException;
import mslinks.ShellLink;
import org.apache.commons.io.FilenameUtils;
import us.ihmc.commons.Conversions;
import us.ihmc.log.LogTools;
import us.ihmc.scs2.definition.robot.RobotDefinition;
import us.ihmc.scs2.definition.robot.RobotStateDefinition;
import us.ihmc.scs2.definition.robot.sdf.SDFTools;
import us.ihmc.scs2.definition.robot.sdf.items.SDFModel;
import us.ihmc.scs2.definition.robot.sdf.items.SDFRoot;
import us.ihmc.scs2.definition.robot.urdf.URDFTools;
import us.ihmc.scs2.definition.robot.urdf.items.URDFModel;
import us.ihmc.scs2.definition.terrain.TerrainObjectDefinition;
import us.ihmc.scs2.definition.yoGraphic.YoGraphicDefinition;
import us.ihmc.scs2.session.Session;
import us.ihmc.scs2.session.SessionMode;
import us.ihmc.scs2.session.SessionRobotDefinitionListChange;
import us.ihmc.scs2.session.mcap.MCAPLogFileReader;
import us.ihmc.scs2.session.mcap.RobotStateUpdater;
import us.ihmc.scs2.sharedMemory.interfaces.YoBufferPropertiesReadOnly;
import us.ihmc.scs2.sharedMemory.tools.SharedMemoryTools;
import us.ihmc.scs2.simulation.robot.Robot;
import us.ihmc.yoVariables.registry.YoRegistry;

public class MCAPLogSession
extends Session {
    private final String sessionName = ((Object)((Object)this)).getClass().getSimpleName();
    private final List<Robot> robots = new ArrayList<Robot>();
    private final List<RobotDefinition> robotDefinitions = new ArrayList<RobotDefinition>();
    private final List<YoGraphicDefinition> yoGraphicDefinitions = new ArrayList<YoGraphicDefinition>();
    private final File initialRobotModelFile;
    private RobotStateUpdater robotStateUpdater = null;
    private final MCAPLogFileReader mcapLogFileReader;
    private final YoRegistry mcapRegistry = new YoRegistry("MCAP");
    private final AtomicInteger logPositionRequest = new AtomicInteger(-1);
    private boolean firstLogPositionRequest = true;

    public MCAPLogSession(File mcapFile, long desiredLogDT, File robotModelFile) throws Exception {
        this.mcapLogFileReader = new MCAPLogFileReader(mcapFile, desiredLogDT, this.getInertialFrame(), this.mcapRegistry);
        this.mcapLogFileReader.loadSchemas();
        this.mcapLogFileReader.loadChannels();
        this.yoGraphicDefinitions.add(this.mcapLogFileReader.getYoGraphic());
        if (robotModelFile == null) {
            ArrayList<File> files = new ArrayList<File>(Arrays.asList(Objects.requireNonNull(mcapFile.getParentFile().listFiles())));
            ArrayList<File> modelFiles = new ArrayList<File>();
            for (int i = 0; i < files.size(); ++i) {
                File file = (File)files.get(i);
                if (!FilenameUtils.isExtension((String)file.getName(), (String)"lnk")) continue;
                try {
                    File targetFile = new File(new ShellLink(file).resolveTarget());
                    if (!targetFile.exists()) continue;
                    files.add(targetFile);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            for (File file : files) {
                if (!FilenameUtils.isExtension((String)file.getName(), (String)"urdf") && !FilenameUtils.isExtension((String)file.getName(), (String)"sdf")) continue;
                modelFiles.add(file);
            }
            if (modelFiles.size() == 1) {
                robotModelFile = (File)modelFiles.get(0);
                LogTools.info((String)("Found a robot model file in the same directory as the MCAP file: " + robotModelFile.getAbsolutePath()));
            } else {
                LogTools.error((String)("Could not find a robot model file in the same directory as the MCAP file: " + mcapFile.getAbsolutePath() + ", found candidates: " + modelFiles));
            }
        }
        RobotDefinition robotDefinition = null;
        this.initialRobotModelFile = robotModelFile;
        if (robotModelFile != null) {
            robotDefinition = MCAPLogSession.loadRobotDefinition(robotModelFile);
        }
        if (robotDefinition != null) {
            Robot robotToAdd = new Robot(robotDefinition, this.getInertialFrame());
            this.robots.add(robotToAdd);
            this.robotDefinitions.add(robotDefinition);
            this.rootRegistry.addChild(robotToAdd.getRegistry());
            this.robotStateUpdater = this.mcapLogFileReader.createRobotStateUpdater(robotToAdd);
            if (this.robotStateUpdater == null) {
                LogTools.warn((String)("Unable to create a robot state updater for robot: " + robotDefinition.getName()));
            }
        }
        this.rootRegistry.addChild(this.mcapRegistry);
        this.setDesiredBufferPublishPeriod(Conversions.secondsToNanoseconds((double)0.03333333333333333));
        this.setSessionDTNanoseconds(desiredLogDT);
        this.setSessionMode(SessionMode.PAUSE);
    }

    public File getInitialRobotModelFile() {
        return this.initialRobotModelFile;
    }

    public long getDesiredLogDT() {
        return this.mcapLogFileReader.getDesiredLogDT();
    }

    public void submitLogPositionRequest(int logPosition) {
        this.logPositionRequest.set(logPosition);
    }

    protected void initializeSession() {
        try {
            this.mcapLogFileReader.initialize();
            if (this.robotStateUpdater != null) {
                this.robotStateUpdater.updateRobotState();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected double doSpecificRunTick() {
        if (this.mcapLogFileReader.incrementTimestamp()) {
            this.setSessionMode(SessionMode.PAUSE);
        } else {
            try {
                this.mcapLogFileReader.readMessagesAtCurrentTimestamp();
            }
            catch (IOException e) {
                this.setSessionMode(SessionMode.PAUSE);
                throw new RuntimeException(e);
            }
        }
        if (this.robotStateUpdater != null) {
            this.robotStateUpdater.updateRobotState();
        }
        return this.mcapLogFileReader.getCurrentTimeInLog();
    }

    public void pauseTick() {
        if (this.firstPauseTick) {
            this.firstLogPositionRequest = true;
        }
        this.processRobotDefinitionRequests();
        int logPosition = this.logPositionRequest.getAndSet(-1);
        if (logPosition == -1) {
            super.pauseTick();
        } else {
            this.processBufferRequests(false);
            this.mcapLogFileReader.setCurrentTimestamp(this.mcapLogFileReader.getChunkManager().getTimestampAtIndex(logPosition));
            try {
                this.mcapLogFileReader.readMessagesAtCurrentTimestamp();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (this.robotStateUpdater != null) {
                this.robotStateUpdater.updateRobotState();
            }
            if (this.firstLogPositionRequest) {
                this.sharedBuffer.incrementBufferIndex(true);
                this.firstLogPositionRequest = false;
            }
            this.sharedBuffer.writeBuffer();
            this.sharedBuffer.prepareLinkedBuffersForPull();
            this.publishBufferProperties(this.sharedBuffer.getProperties());
        }
    }

    private void processRobotDefinitionRequests() {
        SessionRobotDefinitionListChange request = (SessionRobotDefinitionListChange)this.pendingRobotDefinitionListChange.poll();
        if (request == null) {
            return;
        }
        RobotDefinition removedRobot = null;
        RobotDefinition addedRobot = null;
        if (request.getRemovedRobotDefinition() != null) {
            RobotDefinition robotDefinitionToRemove = request.getRemovedRobotDefinition();
            Robot robotToRemove = this.robots.stream().filter(robot -> robot.getRobotDefinition() == robotDefinitionToRemove).findFirst().orElse(null);
            if (robotToRemove != null) {
                this.robots.remove(robotToRemove);
                this.robotDefinitions.remove(robotDefinitionToRemove);
                this.robotStateUpdater = null;
                robotToRemove.destroy();
                removedRobot = robotDefinitionToRemove;
            }
        }
        RobotDefinition robotDefinitionToAdd = null;
        if (request.getNewRobotModelFile() != null) {
            robotDefinitionToAdd = MCAPLogSession.loadRobotDefinition(request.getNewRobotModelFile());
        } else if (request.getAddedRobotDefinition() != null) {
            robotDefinitionToAdd = request.getAddedRobotDefinition();
        }
        if (robotDefinitionToAdd != null) {
            Robot robotToAdd = new Robot(robotDefinitionToAdd, this.getInertialFrame());
            this.robots.add(robotToAdd);
            this.robotDefinitions.add(robotDefinitionToAdd);
            this.rootRegistry.addChild(robotToAdd.getRegistry());
            this.robotStateUpdater = this.mcapLogFileReader.createRobotStateUpdater(robotToAdd);
            if (this.robotStateUpdater == null) {
                LogTools.warn((String)("Unable to create a robot state updater for robot: " + robotDefinitionToAdd.getName()));
            }
            if (this.robotStateUpdater != null) {
                YoBufferPropertiesReadOnly bufferProperties = this.getBufferProperties();
                int previousBufferIndex = bufferProperties.getCurrentIndex();
                int historyIndex = bufferProperties.getInPoint();
                for (int i = 0; i < bufferProperties.getActiveBufferLength(); ++i) {
                    this.sharedBuffer.setCurrentIndex(historyIndex);
                    this.sharedBuffer.readBuffer();
                    this.robotStateUpdater.updateRobotState();
                    this.sharedBuffer.writeBuffer();
                    historyIndex = SharedMemoryTools.increment((int)historyIndex, (int)1, (int)bufferProperties.getSize());
                }
                this.sharedBuffer.setCurrentIndex(previousBufferIndex);
                this.sharedBuffer.readBuffer();
                this.robotStateUpdater.updateRobotState();
                this.sharedBuffer.writeBuffer();
            }
            addedRobot = robotDefinitionToAdd;
        }
        if (addedRobot != null && removedRobot != null) {
            this.reportRobotDefinitionListChange(SessionRobotDefinitionListChange.replace(addedRobot, removedRobot));
        } else if (addedRobot != null) {
            this.reportRobotDefinitionListChange(SessionRobotDefinitionListChange.add(addedRobot));
        } else if (removedRobot != null) {
            this.reportRobotDefinitionListChange(SessionRobotDefinitionListChange.remove(removedRobot));
        }
    }

    private static RobotDefinition loadRobotDefinition(File robotDefinitionFile) {
        if (FilenameUtils.isExtension((String)robotDefinitionFile.getName(), (String)"urdf")) {
            try {
                URDFTools.URDFParserProperties urdfParserProperties = new URDFTools.URDFParserProperties();
                urdfParserProperties.setSimplifyKinematics(false);
                urdfParserProperties.setTransformToZUp(false);
                URDFModel urdfModel = URDFTools.loadURDFModel((File)robotDefinitionFile, Collections.singletonList(robotDefinitionFile.getParent()));
                RobotDefinition robotDefinition = URDFTools.toRobotDefinition((URDFModel)urdfModel, (URDFTools.URDFParserProperties)urdfParserProperties);
                robotDefinition.sanitizeNames();
                if (robotDefinition.getName() == null) {
                    robotDefinition.setName(FilenameUtils.getBaseName((String)robotDefinitionFile.getName()));
                }
                return robotDefinition;
            }
            catch (JAXBException e) {
                LogTools.error((String)("Failed to load URDF model from file: " + robotDefinitionFile.getAbsolutePath() + ".\n" + e.getMessage()));
                return null;
            }
        }
        if (FilenameUtils.isExtension((String)robotDefinitionFile.getName(), (String)"sdf")) {
            try {
                SDFRoot sdfRoot = SDFTools.loadSDFRoot((File)robotDefinitionFile, Collections.singletonList(robotDefinitionFile.getParent()));
                return SDFTools.toFloatingRobotDefinition((SDFModel)((SDFModel)sdfRoot.getModels().get(0)));
            }
            catch (JAXBException e) {
                LogTools.error((String)("Failed to load SDF model from file: " + robotDefinitionFile.getAbsolutePath() + ".\n" + e.getMessage()));
                return null;
            }
        }
        LogTools.error((String)("Unknown robot definition file extension: " + robotDefinitionFile.getName()));
        return null;
    }

    public void submitRobotDefinitionListChange(SessionRobotDefinitionListChange change) {
        this.setSessionMode(SessionMode.PAUSE);
        super.submitRobotDefinitionListChange(change);
    }

    public String getSessionName() {
        return this.sessionName;
    }

    public List<RobotDefinition> getRobotDefinitions() {
        return this.robotDefinitions;
    }

    public List<TerrainObjectDefinition> getTerrainObjectDefinitions() {
        return Collections.emptyList();
    }

    public List<YoGraphicDefinition> getYoGraphicDefinitions() {
        return this.yoGraphicDefinitions;
    }

    public List<RobotStateDefinition> getCurrentRobotStateDefinitions(boolean initialState) {
        return this.robots.stream().map(Robot::getCurrentRobotStateDefinition).collect(Collectors.toList());
    }

    public MCAPLogFileReader getMCAPLogFileReader() {
        return this.mcapLogFileReader;
    }

    public long getRelativeTimestampAtIndex(int index) {
        return this.mcapLogFileReader.getRelativeTimestampAtIndex(index);
    }

    public File getMCAPFile() {
        return this.mcapLogFileReader.getMcapFile();
    }
}

