/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.session.mcap;

import gnu.trove.list.array.TLongArrayList;
import gnu.trove.map.hash.TLongObjectHashMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import us.ihmc.scs2.session.mcap.MCAP;

public class MCAPChunkManager {
    private final TLongArrayList allMessageTimestamps = new TLongArrayList();
    private final List<MCAP.ChunkIndex> mcapChunkIndices = new ArrayList<MCAP.ChunkIndex>();
    private final long desiredLogDT;
    private int numberOfLoadedChunks = -1;
    private ChunkExtra loadedChunkA = new ChunkExtra();
    private ChunkExtra loadedChunkB = new ChunkExtra();

    public MCAPChunkManager(long desiredLogDT) {
        this.desiredLogDT = desiredLogDT;
    }

    public long getTimestampAtIndex(int index) {
        return this.allMessageTimestamps.get(index);
    }

    public long getRelativeTimestampAtIndex(int index) {
        return this.allMessageTimestamps.get(index) - this.firstMessageTimestamp();
    }

    public int getIndexFromTimestamp(long timestamp) {
        int index = this.allMessageTimestamps.binarySearch(timestamp);
        if (index < 0) {
            index = -(index + 1);
        }
        return index;
    }

    public int getNumberOfEntries() {
        return this.allMessageTimestamps.size();
    }

    public void loadFromMCAP(MCAP mcap) {
        for (MCAP.Record record : mcap.records()) {
            if (record.op() == MCAP.Opcode.CHUNK_INDEX) {
                this.mcapChunkIndices.add((MCAP.ChunkIndex)record.body());
                continue;
            }
            if (record.op() != MCAP.Opcode.MESSAGE_INDEX) continue;
            MCAP.MessageIndex messageIndex = (MCAP.MessageIndex)record.body();
            for (MCAP.MessageIndex.MessageIndexEntry mcapEntry : messageIndex.records()) {
                int insertion;
                long timestamp = MCAPChunkManager.round(mcapEntry.logTime(), this.desiredLogDT);
                if (this.allMessageTimestamps.isEmpty() || timestamp > this.allMessageTimestamps.get(this.allMessageTimestamps.size() - 1)) {
                    this.allMessageTimestamps.add(timestamp);
                    continue;
                }
                if (timestamp == this.allMessageTimestamps.get(this.allMessageTimestamps.size() - 1) || (insertion = this.allMessageTimestamps.binarySearch(timestamp)) >= 0) continue;
                this.allMessageTimestamps.insert(-insertion - 1, timestamp);
            }
            record.unloadBody();
        }
        this.mcapChunkIndices.sort(Comparator.comparingLong(chunkIndex -> MCAPChunkManager.round(chunkIndex.messageStartTime(), this.desiredLogDT)));
    }

    public long firstMessageTimestamp() {
        return MCAPChunkManager.round(this.mcapChunkIndices.get(0).messageStartTime(), this.desiredLogDT);
    }

    public long lastMessageTimestamp() {
        return MCAPChunkManager.round(this.mcapChunkIndices.get(this.mcapChunkIndices.size() - 1).messageEndTime(), this.desiredLogDT);
    }

    public long nextMessageTimestamp(long timestamp) {
        if (timestamp < this.allMessageTimestamps.get(0)) {
            return this.allMessageTimestamps.get(0);
        }
        if (timestamp >= this.allMessageTimestamps.get(this.allMessageTimestamps.size() - 1)) {
            return -1L;
        }
        int index = this.allMessageTimestamps.binarySearch(timestamp);
        index = index < 0 ? -(index + 1) + 1 : ++index;
        return this.allMessageTimestamps.get(index);
    }

    public long previousMessageTimestamp(long timestamp) {
        if (timestamp <= this.allMessageTimestamps.get(0)) {
            return -1L;
        }
        if (timestamp > this.allMessageTimestamps.get(this.allMessageTimestamps.size() - 1)) {
            return this.allMessageTimestamps.get(this.allMessageTimestamps.size() - 1);
        }
        int index = this.allMessageTimestamps.binarySearch(timestamp);
        index = index < 0 ? -(index + 1) : --index;
        return this.allMessageTimestamps.get(index);
    }

    public List<MCAP.Message> loadMessages(long timestamp) throws IOException {
        if (timestamp <= this.getActiveChunkStartTimestamp() || timestamp >= this.getActiveChunkEndTimestamp()) {
            this.loadChunk(timestamp);
        }
        if (this.numberOfLoadedChunks <= 0) {
            return Collections.emptyList();
        }
        if (this.numberOfLoadedChunks == 1) {
            return (List)this.loadedChunkA.bundledMessages.get(timestamp);
        }
        if (this.numberOfLoadedChunks == 2) {
            List bundleMessagesA = (List)this.loadedChunkA.bundledMessages.get(timestamp);
            List bundleMessagesB = (List)this.loadedChunkB.bundledMessages.get(timestamp);
            int length = 0;
            if (bundleMessagesA != null) {
                length += bundleMessagesA.size();
            }
            if (bundleMessagesB != null) {
                length += bundleMessagesB.size();
            }
            ArrayList<MCAP.Message> messages = new ArrayList<MCAP.Message>(length);
            if (bundleMessagesA != null) {
                messages.addAll(bundleMessagesA);
            }
            if (bundleMessagesB != null) {
                messages.addAll(bundleMessagesB);
            }
            return messages;
        }
        throw new RuntimeException("Unexpected number of chunks: " + this.numberOfLoadedChunks);
    }

    public boolean loadChunk(long timestamp) throws IOException {
        int indexA;
        int index = timestamp == this.getActiveChunkEndTimestamp() ? (this.numberOfLoadedChunks == 1 ? this.loadedChunkA.index : this.loadedChunkB.index) : this.searchMCAPChunkIndex(timestamp);
        if (index < 0) {
            this.numberOfLoadedChunks = 0;
            return false;
        }
        int prevIndexA = this.loadedChunkA.index;
        int prevIndexB = this.loadedChunkB.index;
        int indexB = -1;
        MCAP.ChunkIndex mcapChunkIndex = this.mcapChunkIndices.get(index);
        if (timestamp == MCAPChunkManager.round(mcapChunkIndex.messageStartTime(), this.desiredLogDT) && index > 0) {
            indexA = index - 1;
            indexB = index;
        } else if (timestamp == MCAPChunkManager.round(mcapChunkIndex.messageEndTime(), this.desiredLogDT) && index < this.mcapChunkIndices.size() - 1) {
            indexA = index;
            indexB = index + 1;
        } else {
            this.numberOfLoadedChunks = 1;
            if (index == prevIndexA) {
                return true;
            }
            if (index == prevIndexB) {
                this.swapChunks();
                this.loadedChunkB.clear();
                if (prevIndexA > -1) {
                    this.mcapChunkIndices.get(prevIndexA).unloadChunk();
                }
                return true;
            }
            if (prevIndexB > -1) {
                this.loadedChunkB.clear();
                this.mcapChunkIndices.get(prevIndexB).unloadChunk();
            }
            this.loadedChunkA.clear();
            this.loadedChunkA.index = index;
            this.loadedChunkA.initialize((MCAP.Chunk)mcapChunkIndex.chunk().body());
            if (prevIndexA > -1) {
                this.mcapChunkIndices.get(prevIndexA).unloadChunk();
            }
            return true;
        }
        this.numberOfLoadedChunks = 2;
        MCAP.ChunkIndex mcapChunkIndexA = this.mcapChunkIndices.get(indexA);
        MCAP.ChunkIndex mcapChunkIndexB = this.mcapChunkIndices.get(indexB);
        if (indexA == prevIndexB || indexB == prevIndexA) {
            this.swapChunks();
            int tmp = prevIndexA;
            prevIndexA = prevIndexB;
            prevIndexB = tmp;
        }
        if (indexA == prevIndexA) {
            if (indexB == prevIndexB) {
                return true;
            }
            this.loadedChunkB.clear();
            this.loadedChunkB.index = indexB;
            this.loadedChunkB.initialize((MCAP.Chunk)mcapChunkIndexB.chunk().body());
            if (prevIndexB > -1) {
                this.mcapChunkIndices.get(prevIndexB).unloadChunk();
            }
        } else if (indexB == prevIndexB) {
            this.loadedChunkA.clear();
            this.loadedChunkA.index = indexA;
            this.loadedChunkA.initialize((MCAP.Chunk)mcapChunkIndexA.chunk().body());
            if (prevIndexA > -1) {
                this.mcapChunkIndices.get(prevIndexA).unloadChunk();
            }
        } else {
            this.loadedChunkA.clear();
            this.loadedChunkA.index = indexA;
            this.loadedChunkA.initialize((MCAP.Chunk)mcapChunkIndexA.chunk().body());
            this.loadedChunkB.clear();
            this.loadedChunkB.index = indexB;
            this.loadedChunkB.initialize((MCAP.Chunk)mcapChunkIndexB.chunk().body());
            if (prevIndexA > -1) {
                this.mcapChunkIndices.get(prevIndexA).unloadChunk();
            }
            if (prevIndexB > -1) {
                this.mcapChunkIndices.get(prevIndexB).unloadChunk();
            }
        }
        return true;
    }

    private void swapChunks() {
        ChunkExtra temp = this.loadedChunkA;
        this.loadedChunkA = this.loadedChunkB;
        this.loadedChunkB = temp;
    }

    public long getActiveChunkStartTimestamp() {
        if (this.numberOfLoadedChunks <= 0) {
            return -1L;
        }
        return MCAPChunkManager.round(this.loadedChunkA.chunk.messageStartTime(), this.desiredLogDT);
    }

    public long getActiveChunkEndTimestamp() {
        if (this.numberOfLoadedChunks <= 0) {
            return -1L;
        }
        if (this.numberOfLoadedChunks == 1) {
            return MCAPChunkManager.round(this.loadedChunkA.chunk.messageEndTime(), this.desiredLogDT);
        }
        if (this.numberOfLoadedChunks == 2) {
            return MCAPChunkManager.round(this.loadedChunkB.chunk.messageEndTime(), this.desiredLogDT);
        }
        throw new RuntimeException("Unexpected number of chunks: " + this.numberOfLoadedChunks);
    }

    private int searchMCAPChunkIndex(long timestamp) {
        if (this.mcapChunkIndices.isEmpty()) {
            return -1;
        }
        int low = 0;
        int high = this.mcapChunkIndices.size() - 1;
        if (timestamp < MCAPChunkManager.round(this.mcapChunkIndices.get(low).messageStartTime(), this.desiredLogDT)) {
            return -1;
        }
        if (timestamp > MCAPChunkManager.round(this.mcapChunkIndices.get(high).messageEndTime(), this.desiredLogDT)) {
            return -1;
        }
        while (low <= high) {
            int mid = low + high >>> 1;
            MCAP.ChunkIndex midVal = this.mcapChunkIndices.get(mid);
            long midValStartTime = MCAPChunkManager.round(midVal.messageStartTime(), this.desiredLogDT);
            if (timestamp == midValStartTime) {
                return mid;
            }
            if (timestamp > midValStartTime) {
                if (timestamp <= MCAPChunkManager.round(midVal.messageEndTime(), this.desiredLogDT)) {
                    return mid;
                }
                low = mid + 1;
                continue;
            }
            high = mid - 1;
        }
        return -1;
    }

    static long round(long value, long step) {
        if (step <= 1L) {
            return value;
        }
        long floor = value / step * step;
        long ceil = floor + step;
        return value - floor < ceil - value ? floor : ceil;
    }

    private class ChunkExtra {
        private int index = -1;
        private MCAP.Chunk chunk;
        private final TLongObjectHashMap<List<MCAP.Message>> bundledMessages = new TLongObjectHashMap();

        private ChunkExtra() {
        }

        private void clear() {
            this.index = -1;
            this.chunk = null;
            this.bundledMessages.clear();
        }

        public void initialize(MCAP.Chunk chunk) throws IOException {
            this.chunk = chunk;
            for (MCAP.Record record : chunk.records()) {
                if (record.op() != MCAP.Opcode.MESSAGE) continue;
                MCAP.Message message = (MCAP.Message)record.body();
                ArrayList<MCAP.Message> messages = (ArrayList<MCAP.Message>)this.bundledMessages.get(MCAPChunkManager.round(message.logTime(), MCAPChunkManager.this.desiredLogDT));
                if (messages == null) {
                    messages = new ArrayList<MCAP.Message>();
                    this.bundledMessages.put(MCAPChunkManager.round(message.logTime(), MCAPChunkManager.this.desiredLogDT), messages);
                }
                messages.add(message);
            }
        }
    }
}

