/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.session.remote;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import us.ihmc.robotDataLogger.websocket.command.DataServerCommand;

public class LoggerStatusUpdater {
    private static final int LOGGER_STATUS_TIMEOUT_SECONDS = 6;
    private final Object schedulerLock = new Object();
    private final ScheduledExecutorService offlineExecutor = Executors.newSingleThreadScheduledExecutor();
    private ScheduledFuture<?> offlineExecutorFuture = null;
    private final AtomicBoolean isLogging = new AtomicBoolean(false);
    private final AtomicInteger currentLogDuration = new AtomicInteger(-1);
    private final AtomicBoolean isCameraRecording = new AtomicBoolean(false);

    public LoggerStatusUpdater() {
        this.reportLoggerOffline();
    }

    public void updateStatus(DataServerCommand command, int argument) {
        if (command == DataServerCommand.LOG_ACTIVE_WITH_CAMERA) {
            this.isLogging.set(true);
            this.isCameraRecording.set(true);
            this.currentLogDuration.set(argument);
            this.startLoggerOfflineTimeout();
        } else if (command == DataServerCommand.LOG_ACTIVE) {
            this.isLogging.set(true);
            this.isCameraRecording.set(false);
            this.currentLogDuration.set(argument);
            this.startLoggerOfflineTimeout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startLoggerOfflineTimeout() {
        Object object = this.schedulerLock;
        synchronized (object) {
            if (this.offlineExecutorFuture != null) {
                this.offlineExecutorFuture.cancel(false);
            }
            this.offlineExecutorFuture = this.offlineExecutor.schedule(() -> this.reportLoggerOffline(), 6L, TimeUnit.SECONDS);
        }
    }

    private void reportLoggerOffline() {
        this.isLogging.set(false);
        this.isCameraRecording.set(false);
        this.currentLogDuration.set(-1);
    }

    public boolean isLogging() {
        return this.isLogging.get();
    }

    public boolean isCameraRecording() {
        return this.isCameraRecording.get();
    }

    public int getCurrentLogDuration() {
        return this.currentLogDuration.get();
    }
}

