/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.session.mcap;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.log.LogTools;
import us.ihmc.scs2.session.mcap.MCAPLogCropper;
import us.ihmc.scs2.session.mcap.MCAPLogFileReader;
import us.ihmc.scs2.session.mcap.encoding.MCAPCRC32Helper;
import us.ihmc.scs2.session.mcap.input.MCAPDataInput;
import us.ihmc.scs2.session.mcap.output.MCAPByteBufferDataOutput;
import us.ihmc.scs2.session.mcap.output.MCAPDataOutput;
import us.ihmc.scs2.session.mcap.specs.MCAP;
import us.ihmc.scs2.session.mcap.specs.records.Chunk;
import us.ihmc.scs2.session.mcap.specs.records.ChunkIndex;
import us.ihmc.scs2.session.mcap.specs.records.DataEnd;
import us.ihmc.scs2.session.mcap.specs.records.Footer;
import us.ihmc.scs2.session.mcap.specs.records.Magic;
import us.ihmc.scs2.session.mcap.specs.records.Message;
import us.ihmc.scs2.session.mcap.specs.records.MessageIndex;
import us.ihmc.scs2.session.mcap.specs.records.MessageIndexEntry;
import us.ihmc.scs2.session.mcap.specs.records.MessageIndexOffset;
import us.ihmc.scs2.session.mcap.specs.records.Opcode;
import us.ihmc.scs2.session.mcap.specs.records.Record;
import us.ihmc.scs2.session.mcap.specs.records.Records;
import us.ihmc.scs2.session.mcap.specs.records.Schema;
import us.ihmc.scs2.session.mcap.specs.records.SummaryOffset;

public class MCAPLogCropperTest {
    @Test
    public void testSimpleCloningMCAP() throws IOException {
        File demoMCAPFile = MCAPLogCropperTest.getDemoMCAPFile();
        MCAP originalMCAP = new MCAP(new FileInputStream(demoMCAPFile).getChannel());
        File clonedDemoMCAPFile = MCAPLogCropperTest.createTempMCAPFile("clonedDemo");
        MCAPDataOutput dataOutput = MCAPDataOutput.wrap((FileChannel)new FileOutputStream(clonedDemoMCAPFile).getChannel());
        dataOutput.putBytes(Magic.MAGIC_BYTES);
        originalMCAP.records().forEach(record -> record.write(dataOutput));
        dataOutput.putBytes(Magic.MAGIC_BYTES);
        dataOutput.close();
        MCAP clonedMCAP = new MCAP(new FileInputStream(clonedDemoMCAPFile).getChannel());
        if (originalMCAP.records().size() != clonedMCAP.records().size()) {
            Assertions.fail((String)"Original and cloned MCAPs have different number of records");
        }
        for (int i = 0; i < originalMCAP.records().size(); ++i) {
            Assertions.assertEquals(originalMCAP.records().get(i), clonedMCAP.records().get(i), (String)("Record " + i + " is different"));
        }
        MCAPLogCropperTest.assertFileEquals(demoMCAPFile, clonedDemoMCAPFile);
    }

    private static void assertFileEquals(File expected, File actual) throws IOException {
        try (FileInputStream expectedFileInputStream = new FileInputStream(expected);
             FileInputStream actualFileInputStream = new FileInputStream(actual);){
            byte[] expectedBuffer = new byte[1024];
            byte[] actualBuffer = new byte[1024];
            int expectedRead = 0;
            int actualRead = 0;
            while ((expectedRead = expectedFileInputStream.read(expectedBuffer)) != -1) {
                actualRead = actualFileInputStream.read(actualBuffer);
                if (actualRead == -1) {
                    Assertions.fail((String)"Actual file is shorter than the expected file");
                }
                if (expectedRead != actualRead) {
                    Assertions.fail((String)"Files have different lengths");
                }
                for (int i = 0; i < expectedRead; ++i) {
                    if (expectedBuffer[i] == actualBuffer[i]) continue;
                    Assertions.fail((String)"Files are different");
                }
            }
        }
    }

    @Test
    public void testNotActuallyCroppingMCAPDemoFile() throws IOException {
        File demoMCAPFile = MCAPLogCropperTest.getDemoMCAPFile();
        MCAP originalMCAP = new MCAP(new FileInputStream(demoMCAPFile).getChannel());
        MCAPLogFileReader.exportChunkToFile((Path)MCAPLogFileReader.SCS2_MCAP_DEBUG_HOME, (Chunk)((Chunk)((Record)originalMCAP.records().get(1)).body()), null);
        MCAPLogCropper mcapLogCropper = new MCAPLogCropper(originalMCAP);
        mcapLogCropper.setStartTimestamp(0L);
        mcapLogCropper.setEndTimestamp(Long.MAX_VALUE);
        mcapLogCropper.setOutputFormat(MCAPLogCropper.OutputFormat.MCAP);
        File croppedDemoMCAPFile = MCAPLogCropperTest.createTempMCAPFile("croppedDemo");
        mcapLogCropper.crop(new FileOutputStream(croppedDemoMCAPFile));
        MCAP croppedMCAP = new MCAP(new FileInputStream(croppedDemoMCAPFile).getChannel());
        MCAPLogCropperTest.assertChunksEqual(originalMCAP.records(), croppedMCAP.records());
        MCAPLogCropperTest.assertSchemasEqual(originalMCAP.records(), croppedMCAP.records());
        MCAPLogCropperTest.assertChannelsEqual(originalMCAP.records(), croppedMCAP.records());
        MCAPLogCropperTest.assertAttachmentsEqual(originalMCAP.records(), croppedMCAP.records());
        MCAPLogCropperTest.assertMetadatasEqual(originalMCAP.records(), croppedMCAP.records());
        MCAPLogCropperTest.validateDataEnd(originalMCAP);
        MCAPLogCropperTest.validateChunkIndices(originalMCAP);
        MCAPLogCropperTest.validateMessageIndices(originalMCAP.records());
        MCAPLogCropperTest.validateFooter(originalMCAP);
        MCAPLogCropperTest.validateDataEnd(croppedMCAP);
        MCAPLogCropperTest.validateChunkIndices(croppedMCAP);
        MCAPLogCropperTest.validateMessageIndices(croppedMCAP.records());
        MCAPLogCropperTest.validateFooter(croppedMCAP);
    }

    public static void assertChunksEqual(List<Record> expectedRecords, List<Record> actualRecords) {
        List<Chunk> expectedChunks = expectedRecords.stream().filter(r -> r.op() == Opcode.CHUNK).map(r -> (Chunk)r.body()).toList();
        List<Chunk> actualChunks = actualRecords.stream().filter(r -> r.op() == Opcode.CHUNK).map(r -> (Chunk)r.body()).toList();
        if (expectedChunks.size() != actualChunks.size()) {
            Assertions.fail((String)("Expected " + expectedChunks.size() + " chunks, but found " + actualChunks.size()));
        }
        for (int i = 0; i < expectedChunks.size(); ++i) {
            Chunk expectedChunk = expectedChunks.get(i);
            Chunk actualChunk = actualChunks.stream().filter(c -> c.messageStartTime() == expectedChunk.messageStartTime()).findFirst().orElse(null);
            Assertions.assertNotNull((Object)actualChunk, (String)("Could not find a chunk with message start time " + expectedChunk.messageStartTime()));
            Assertions.assertEquals((long)expectedChunk.messageStartTime(), (long)actualChunk.messageStartTime(), (String)("Chunk " + i + " has different start time"));
            Assertions.assertEquals((long)expectedChunk.messageEndTime(), (long)actualChunk.messageEndTime(), (String)("Chunk " + i + " has different end time"));
            Assertions.assertEquals((long)expectedChunk.recordsUncompressedLength(), (long)actualChunk.recordsUncompressedLength(), (String)("Chunk " + i + " has different uncompressed length"));
            Assertions.assertEquals((Object)expectedChunk.compression(), (Object)actualChunk.compression(), (String)("Chunk " + i + " has different compression"));
            Assertions.assertEquals((Object)expectedChunk.records(), (Object)actualChunk.records(), (String)("Chunk " + i + " has different records"));
            Assertions.assertEquals((long)expectedChunk.uncompressedCRC32(), (long)actualChunk.uncompressedCRC32(), (String)("Chunk " + i + " has different uncompressed CRC32"));
        }
    }

    public static void assertSchemasEqual(List<Record> expectedRecords, List<Record> actualRecords) {
        List<Schema> expectedSchemas = expectedRecords.stream().filter(r -> r.op() == Opcode.SCHEMA).map(r -> (Schema)r.body()).toList();
        List<Schema> actualSchemas = actualRecords.stream().filter(r -> r.op() == Opcode.SCHEMA).map(r -> (Schema)r.body()).toList();
        if (expectedSchemas.size() != actualSchemas.size()) {
            Assertions.fail((String)("Expected " + expectedSchemas.size() + " schemas, but found " + actualSchemas.size()));
        }
        for (int i = 0; i < expectedSchemas.size(); ++i) {
            Schema expectedSchema = expectedSchemas.get(i);
            Schema actualSchema = actualSchemas.stream().filter(s -> s.id() == expectedSchema.id()).findFirst().orElse(null);
            Assertions.assertNotNull((Object)actualSchema, (String)("Could not find a schema with ID " + expectedSchema.id()));
            Assertions.assertEquals((Object)expectedSchema, (Object)actualSchema, (String)("Schema " + i + " is different"));
        }
    }

    public static void assertChannelsEqual(List<Record> expectedRecords, List<Record> actualRecords) {
        List<Record> expectedChannels = expectedRecords.stream().filter(r -> r.op() == Opcode.CHANNEL).toList();
        List<Record> actualChannels = actualRecords.stream().filter(r -> r.op() == Opcode.CHANNEL).toList();
        if (expectedChannels.size() != actualChannels.size()) {
            Assertions.fail((String)("Expected " + expectedChannels.size() + " channels, but found " + actualChannels.size()));
        }
        for (int i = 0; i < expectedChannels.size(); ++i) {
            Assertions.assertEquals((Object)expectedChannels.get(i), (Object)actualChannels.get(i), (String)("Channel " + i + " is different"));
        }
    }

    public static void assertAttachmentsEqual(List<Record> expectedRecords, List<Record> actualRecords) {
        List<Record> expectedAttachments = expectedRecords.stream().filter(r -> r.op() == Opcode.ATTACHMENT).toList();
        List<Record> actualAttachments = actualRecords.stream().filter(r -> r.op() == Opcode.ATTACHMENT).toList();
        if (expectedAttachments.size() != actualAttachments.size()) {
            Assertions.fail((String)("Expected " + expectedAttachments.size() + " attachments, but found " + actualAttachments.size()));
        }
        for (int i = 0; i < expectedAttachments.size(); ++i) {
            Assertions.assertEquals((Object)expectedAttachments.get(i), (Object)actualAttachments.get(i), (String)("Attachment " + i + " is different"));
        }
    }

    public static void assertMetadatasEqual(List<Record> expectedRecords, List<Record> actualRecords) {
        List<Record> expectedMetadatas = expectedRecords.stream().filter(r -> r.op() == Opcode.METADATA).toList();
        List<Record> actualMetadatas = actualRecords.stream().filter(r -> r.op() == Opcode.METADATA).toList();
        if (expectedMetadatas.size() != actualMetadatas.size()) {
            Assertions.fail((String)("Expected " + expectedMetadatas.size() + " metadatas, but found " + actualMetadatas.size()));
        }
        for (int i = 0; i < expectedMetadatas.size(); ++i) {
            Assertions.assertEquals((Object)expectedMetadatas.get(i), (Object)actualMetadatas.get(i), (String)("Metadata " + i + " is different"));
        }
    }

    public static void validateDataEnd(MCAP mcap) {
        List<Record> dataEnds = mcap.records().stream().filter(r -> r.op() == Opcode.DATA_END).toList();
        Assertions.assertEquals((int)1, (int)dataEnds.size(), (String)("Expected one data end, but found " + dataEnds.size()));
        Record dataEndRecord = dataEnds.get(0);
        long dataSectionCRC32 = ((DataEnd)dataEndRecord.body()).dataSectionCRC32();
        if (dataSectionCRC32 != 0L) {
            MCAPCRC32Helper crc32 = new MCAPCRC32Helper();
            crc32.addBytes(Magic.MAGIC_BYTES);
            mcap.records().stream().takeWhile(r -> r.op() != Opcode.DATA_END).forEach(r -> r.updateCRC(crc32));
            Assertions.assertEquals((long)crc32.getValue(), (long)dataSectionCRC32, (String)"Data end has different CRC32");
        }
    }

    public static void validateChunkIndices(MCAP mcap) {
        List<Record> chunkIndices = mcap.records().stream().filter(r -> r.op() == Opcode.CHUNK_INDEX).toList();
        if (chunkIndices.isEmpty()) {
            Assertions.fail((String)"No chunk index found");
        }
        for (int i = 0; i < chunkIndices.size(); ++i) {
            ChunkIndex chunkIndex = (ChunkIndex)chunkIndices.get(i).body();
            Record chunkRecord = chunkIndex.chunk();
            if (chunkRecord == null) {
                Assertions.fail((String)("Chunk index " + i + " has no chunk"));
            }
            if (chunkRecord.op() != Opcode.CHUNK) {
                Assertions.fail((String)("Chunk index " + i + " has a record that is not a chunk"));
            }
            Chunk chunk = (Chunk)chunkRecord.body();
            Assertions.assertEquals((long)chunkIndex.messageStartTime(), (long)chunk.messageStartTime(), (String)("Chunk index " + i + " has different start time"));
            Assertions.assertEquals((long)chunkIndex.messageEndTime(), (long)chunk.messageEndTime(), (String)("Chunk index " + i + " has different end time"));
            Assertions.assertEquals((long)chunkIndex.recordsUncompressedLength(), (long)chunk.recordsUncompressedLength(), (String)("Chunk index " + i + " has different uncompressed length"));
            Assertions.assertEquals((Object)chunkIndex.compression(), (Object)chunk.compression(), (String)("Chunk index " + i + " has different compression"));
            Assertions.assertEquals((long)chunkIndex.recordsCompressedLength(), (long)chunk.recordsCompressedLength(), (String)("Chunk index " + i + " has different compressed length"));
            for (MessageIndexOffset messageIndexOffset : chunkIndex.messageIndexOffsets()) {
                Assertions.assertTrue((messageIndexOffset.offset() >= 0L ? 1 : 0) != 0, (String)("Chunk index " + i + " has a message index offset that is negative"));
                int channelId = messageIndexOffset.channelId();
                long offset = messageIndexOffset.offset();
                Record messageIndexRecord = Record.load((MCAPDataInput)mcap.getDataInput(), (long)offset);
                Assertions.assertEquals((Object)Opcode.MESSAGE_INDEX, (Object)messageIndexRecord.op(), (String)("Chunk index " + i + " has a message index record that is not a message index"));
                MessageIndex messageIndex = (MessageIndex)messageIndexRecord.body();
                Assertions.assertEquals((int)channelId, (int)messageIndex.channelId(), (String)("Chunk index " + i + " has a message index record with different channel ID"));
            }
        }
    }

    public static void validateMessageIndices(List<Record> records) {
        List<MessageIndex> messageIndices = records.stream().filter(r -> r.op() == Opcode.MESSAGE_INDEX).map(r -> (MessageIndex)r.body()).toList();
        if (messageIndices.isEmpty()) {
            Assertions.fail((String)"No message index found");
        }
        List<ChunkIndex> chunkIndices = records.stream().filter(r -> r.op() == Opcode.CHUNK_INDEX).map(r -> (ChunkIndex)r.body()).toList();
        for (int i = 0; i < messageIndices.size(); ++i) {
            MessageIndex messageIndex = messageIndices.get(i);
            for (MessageIndexEntry messageIndexEntry : messageIndex.messageIndexEntries()) {
                long logTime = messageIndexEntry.logTime();
                ChunkIndex chunkIndex = chunkIndices.stream().filter(c -> c.messageStartTime() <= logTime && c.messageEndTime() >= logTime).findFirst().orElse(null);
                Assertions.assertNotNull((Object)chunkIndex, (String)("Could not find a chunk index for message index entry " + String.valueOf(messageIndexEntry)));
                Chunk chunk = (Chunk)chunkIndex.chunk().body();
                ByteBuffer recordsUncompressedBuffer = chunk.getRecordsUncompressedBuffer();
                MCAPDataInput dataInput = MCAPDataInput.wrap((ByteBuffer)recordsUncompressedBuffer);
                Record messageRecord = Record.load((MCAPDataInput)dataInput, (long)messageIndexEntry.offset());
                Assertions.assertEquals((Object)Opcode.MESSAGE, (Object)messageRecord.op(), (String)("Message index entry " + String.valueOf(messageIndexEntry) + " does not point to a message record"));
                Message message = (Message)messageRecord.body();
                Assertions.assertEquals((long)logTime, (long)message.logTime(), (String)("Message index entry " + String.valueOf(messageIndexEntry) + " points to a message with different log time"));
            }
        }
    }

    public static void validateFooter(MCAP mcap) {
        List<Record> footerRecords = mcap.records().stream().filter(r -> r.op() == Opcode.FOOTER).toList();
        Assertions.assertEquals((int)1, (int)footerRecords.size(), (String)("Expected one footer, but found " + footerRecords.size()));
        Record footerRecord = footerRecords.get(0);
        Footer footer = (Footer)footerRecord.body();
        Records summarySection = footer.summarySection();
        Records summaryOffsetSection = footer.summaryOffsetSection();
        MCAPCRC32Helper crc32 = new MCAPCRC32Helper();
        summarySection.forEach(record -> record.updateCRC(crc32));
        summaryOffsetSection.forEach(record -> record.updateCRC(crc32));
        crc32.addUnsignedByte(footerRecord.op().id());
        crc32.addLong(footerRecord.bodyLength());
        crc32.addLong(footer.summarySectionOffset());
        crc32.addLong(footer.summaryOffsetSectionOffset());
        Assertions.assertEquals((long)crc32.getValue(), (long)footer.summaryCRC32(), (String)"Footer has different summary CRC32");
        MCAPByteBufferDataOutput dataOutput = new MCAPByteBufferDataOutput();
        summarySection.forEach(record -> record.write((MCAPDataOutput)dataOutput));
        summaryOffsetSection.forEach(record -> record.write((MCAPDataOutput)dataOutput));
        dataOutput.putUnsignedByte(footerRecord.op().id());
        dataOutput.putLong(footerRecord.bodyLength());
        dataOutput.putLong(footer.summarySectionOffset());
        dataOutput.putLong(footer.summaryOffsetSectionOffset());
        dataOutput.close();
        byte[] expectedSummaryCRC32Input = new byte[dataOutput.getBuffer().remaining()];
        dataOutput.getBuffer().get(expectedSummaryCRC32Input);
        Assertions.assertArrayEquals((byte[])expectedSummaryCRC32Input, (byte[])footer.summaryCRC32Input(), (String)"Footer has different summary CRC32 input");
        Assertions.assertEquals((long)(footer.summarySectionLength() + footer.summaryOffsetSectionLength() + 9L + 16L), (long)footer.summaryCRC32Input().length, (String)"Footer has different summary CRC32 input length");
        crc32.reset();
        crc32.addBytes(footer.summaryCRC32Input());
        Assertions.assertEquals((long)crc32.getValue(), (long)footer.summaryCRC32(), (String)"Footer has different summary CRC32");
        Assertions.assertTrue((boolean)summarySection.stream().allMatch(r -> r.op() == Opcode.SCHEMA || r.op() == Opcode.CHANNEL || r.op() == Opcode.CHUNK_INDEX || r.op() == Opcode.ATTACHMENT_INDEX || r.op() == Opcode.METADATA_INDEX || r.op() == Opcode.STATISTICS), (String)"Summary section contains a record that is not a schema, channel, chunk index, attachment index, metadata index, or statistics");
        Assertions.assertTrue((boolean)summaryOffsetSection.stream().allMatch(r -> r.op() == Opcode.SUMMARY_OFFSET), (String)"Summary offset section contains a record that is not a summary offset");
        for (Record summaryOffsetRecord : summaryOffsetSection) {
            SummaryOffset summaryOffset = (SummaryOffset)summaryOffsetRecord.body();
            Records group = summaryOffset.group();
            Assertions.assertTrue((boolean)group.stream().allMatch(r -> r.op() == summaryOffset.groupOpcode()), (String)"Group contains a record that is not of the expected type");
        }
    }

    public static File getDemoMCAPFile() throws IOException {
        File demoMCAPFile;
        Path localFileVersion = Paths.get(System.getProperty("user.home"), "Downloads", "demo.mcap");
        if (Files.exists(localFileVersion, new LinkOption[0])) {
            demoMCAPFile = localFileVersion.toFile();
        } else {
            URL demoMCAPURL = new URL("https://github.com/foxglove/mcap/raw/main/testdata/mcap/demo.mcap");
            demoMCAPFile = MCAPLogCropperTest.downloadFile(demoMCAPURL);
        }
        return demoMCAPFile;
    }

    private static File downloadFile(URL url) throws IOException {
        File file = MCAPLogCropperTest.createTempMCAPFile(FilenameUtils.getBaseName((String)url.getFile()));
        LogTools.info((String)("Downloading file from " + String.valueOf(url)));
        try (InputStream in = url.openStream();){
            Files.copy(in, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        LogTools.info((String)("Downloaded file to " + file.getAbsolutePath()));
        return file;
    }

    public static File createTempMCAPFile(String name) throws IOException {
        File file = File.createTempFile(name, ".mcap");
        LogTools.info((String)("Created temporary file: " + file.getAbsolutePath()));
        file.deleteOnExit();
        return file;
    }
}

