/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.session.mcap;

import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.scs2.session.mcap.MCAPMessageManager;

public class MCAPMessageManagerTest {
    public static final int ITERATIONS = 1000;

    @Test
    public void testRound() {
        Random random = new Random(234234L);
        for (int i = 0; i < 1000; ++i) {
            long rawValue = random.nextLong();
            if (rawValue < 0L) {
                rawValue = -rawValue;
            }
            long step = TimeUnit.MILLISECONDS.toNanos(random.nextInt(100));
            long roundedValue = MCAPMessageManager.round((long)rawValue, (long)step);
            if (step <= 0L) {
                Assertions.assertEquals((long)rawValue, (long)roundedValue, (String)("Iteration: " + i + ", rawValue: " + rawValue + ", step: " + step + ", roundedValue: " + roundedValue));
                continue;
            }
            long remainder = roundedValue % step;
            Assertions.assertEquals((long)0L, (long)remainder, (String)("Iteration: " + i + ", rawValue: " + rawValue + ", step: " + step + ", roundedValue: " + roundedValue));
        }
    }
}

