/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.examples.simulations.bullet;

import java.util.Collection;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointReadOnly;
import us.ihmc.mecano.tools.MomentOfInertiaFactory;
import us.ihmc.scs2.definition.collision.CollisionShapeDefinition;
import us.ihmc.scs2.definition.controller.interfaces.Controller;
import us.ihmc.scs2.definition.geometry.Cylinder3DDefinition;
import us.ihmc.scs2.definition.geometry.GeometryDefinition;
import us.ihmc.scs2.definition.geometry.Sphere3DDefinition;
import us.ihmc.scs2.definition.robot.JointDefinition;
import us.ihmc.scs2.definition.robot.PrismaticJointDefinition;
import us.ihmc.scs2.definition.robot.RigidBodyDefinition;
import us.ihmc.scs2.definition.robot.RobotDefinition;
import us.ihmc.scs2.definition.state.OneDoFJointState;
import us.ihmc.scs2.definition.state.interfaces.OneDoFJointStateBasics;
import us.ihmc.scs2.definition.visual.ColorDefinitions;
import us.ihmc.scs2.definition.visual.MaterialDefinition;
import us.ihmc.scs2.definition.visual.VisualDefinitionFactory;
import us.ihmc.scs2.session.Session;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizer;
import us.ihmc.scs2.simulation.SimulationSession;
import us.ihmc.scs2.simulation.bullet.physicsEngine.BulletPhysicsEngineFactory;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class PrismaticSpringBulletSimulation {
    private static final String SPRING_PENDULUM = "SpringPendulum";
    private static final boolean VISUALIZE_WITH_DEBUG_DRAWING = false;
    private final double ballRadius = 0.04;
    private final double stringLength = 0.4;
    private final double stringRadius = 0.005;
    private final double ballMass = 0.3;

    public PrismaticSpringBulletSimulation() {
        RobotDefinition robotDefinition = new RobotDefinition(SPRING_PENDULUM);
        double ballRadiusOfGyration = 0.024;
        double pinJointHeight = 0.44000000000000006;
        RigidBodyDefinition rootBody = new RigidBodyDefinition("rootBody");
        robotDefinition.setRootBodyDefinition(rootBody);
        Vector3D offset = new Vector3D(0.2, 0.2, pinJointHeight);
        PrismaticJointDefinition prismaticJoint = new PrismaticJointDefinition("spring");
        prismaticJoint.setAxis((Vector3DReadOnly)Axis3D.Z);
        prismaticJoint.setTransformToParent((RigidBodyTransformReadOnly)new RigidBodyTransform((Orientation3DReadOnly)new Quaternion(), (Tuple3DReadOnly)offset));
        RigidBodyDefinition rigidBody = new RigidBodyDefinition("ball");
        rigidBody.setMass(0.3);
        rigidBody.setMomentOfInertia((Matrix3DReadOnly)MomentOfInertiaFactory.fromMassAndRadiiOfGyration((double)0.3, (double)ballRadiusOfGyration, (double)ballRadiusOfGyration, (double)ballRadiusOfGyration));
        rigidBody.setCenterOfMassOffset(0.0, 0.0, -0.4);
        MaterialDefinition ballMaterial = new MaterialDefinition(ColorDefinitions.Silver(), ColorDefinitions.White(), ColorDefinitions.LightBlue(), ColorDefinitions.AntiqueWhite(), 20.0);
        VisualDefinitionFactory factory = new VisualDefinitionFactory();
        factory.appendTranslation(0.0, 0.0, -0.2);
        factory.addCylinder(0.4, 0.005, ColorDefinitions.DarkSlateGray());
        factory.appendTranslation(0.0, 0.0, -0.2);
        factory.addSphere(0.04, ballMaterial);
        rigidBody.addVisualDefinitions((Collection)factory.getVisualDefinitions());
        rigidBody.addCollisionShapeDefinition(new CollisionShapeDefinition((RigidBodyTransformReadOnly)new RigidBodyTransform((Orientation3DReadOnly)new Quaternion(), (Tuple3DReadOnly)new Vector3D(0.0, 0.0, -0.4)), (GeometryDefinition)new Sphere3DDefinition(0.04)));
        rigidBody.addCollisionShapeDefinition(new CollisionShapeDefinition((RigidBodyTransformReadOnly)new RigidBodyTransform((Orientation3DReadOnly)new Quaternion(), (Tuple3DReadOnly)new Vector3D(0.0, 0.0, -0.2)), (GeometryDefinition)new Cylinder3DDefinition(0.4, 0.005)));
        prismaticJoint.setInitialJointState(new OneDoFJointState(0.3));
        prismaticJoint.setPositionLimits(-0.5, 0.5);
        prismaticJoint.setSuccessor(rigidBody);
        rootBody.addChildJoint((JointDefinition)prismaticJoint);
        robotDefinition.addControllerDefinition((controllerInput, controllerOutput) -> new Controller(){
            YoRegistry registry = new YoRegistry("SpringController");
            YoDouble stiffness = new YoDouble("springStiffness", this.registry);
            YoDouble desiredLength = new YoDouble("springDesiredLength", this.registry);
            OneDoFJointReadOnly sliderJoint = (OneDoFJointReadOnly)controllerInput.getInput().findJoint("spring");
            OneDoFJointStateBasics sliderOutput = controllerOutput.getOneDoFJointOutput("spring");

            public void initialize() {
                this.stiffness.set(1000.0);
                this.desiredLength.set(0.0);
            }

            public void doControl() {
                double currentPosition = this.sliderJoint.getQ();
                double desiredForce = this.stiffness.getValue() * (this.desiredLength.getValue() - currentPosition);
                this.sliderOutput.setEffort(desiredForce);
            }

            public YoRegistry getYoRegistry() {
                return this.registry;
            }
        });
        SimulationSession simulationSession = new SimulationSession(BulletPhysicsEngineFactory.newBulletPhysicsEngineFactory());
        simulationSession.addRobot(robotDefinition);
        SessionVisualizer.startSessionVisualizer((Session)simulationSession);
    }

    public static void main(String[] args) {
        new PrismaticSpringBulletSimulation();
    }
}

