/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.examples.simulations.bullet;

import java.util.Collection;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.scs2.definition.collision.CollisionShapeDefinition;
import us.ihmc.scs2.definition.geometry.Box3DDefinition;
import us.ihmc.scs2.definition.geometry.GeometryDefinition;
import us.ihmc.scs2.definition.robot.JointDefinition;
import us.ihmc.scs2.definition.robot.RevoluteJointDefinition;
import us.ihmc.scs2.definition.robot.RigidBodyDefinition;
import us.ihmc.scs2.definition.robot.RobotDefinition;
import us.ihmc.scs2.definition.robot.SixDoFJointDefinition;
import us.ihmc.scs2.definition.state.OneDoFJointState;
import us.ihmc.scs2.definition.state.SixDoFJointState;
import us.ihmc.scs2.definition.terrain.TerrainObjectDefinition;
import us.ihmc.scs2.definition.visual.ColorDefinition;
import us.ihmc.scs2.definition.visual.ColorDefinitions;
import us.ihmc.scs2.definition.visual.MaterialDefinition;
import us.ihmc.scs2.definition.visual.VisualDefinition;
import us.ihmc.scs2.definition.visual.VisualDefinitionFactory;
import us.ihmc.scs2.examples.simulations.ExampleExperimentalSimulationTools;
import us.ihmc.scs2.session.Session;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizer;
import us.ihmc.scs2.simulation.SimulationSession;
import us.ihmc.scs2.simulation.bullet.physicsEngine.BulletPhysicsEngineFactory;

public class ConnectedShapesExperimentalBulletSimulation {
    private static final boolean VISUALIZE_WITH_DEBUG_DRAWING = false;

    public ConnectedShapesExperimentalBulletSimulation() {
        Vector3D boxSize1 = new Vector3D(0.5, 0.3, 0.3);
        double boxMass1 = 1.0;
        double radiusOfGyrationPercent = 0.8;
        ColorDefinition boxApp1 = ColorDefinitions.LightSeaGreen();
        Vector3D boxSize2 = new Vector3D(0.3, 0.3, 0.3);
        double boxMass2 = 1.0;
        ColorDefinition boxApp2 = ColorDefinitions.Teal();
        double groundWidth = 5.0;
        double groundLength = 5.0;
        Vector3D connectionOffset = new Vector3D(0.9, 0.0, 0.0);
        RobotDefinition robotDefinition = new RobotDefinition("ConnectedShapes");
        RigidBodyDefinition rootBodyDefinition = new RigidBodyDefinition("rootBody");
        SixDoFJointDefinition rootJointDefinition = new SixDoFJointDefinition("rootJoint");
        rootBodyDefinition.addChildJoint((JointDefinition)rootJointDefinition);
        RigidBodyDefinition rigidBody1 = ExampleExperimentalSimulationTools.newBoxRigidBody("box1", (Tuple3DReadOnly)boxSize1, boxMass1, radiusOfGyrationPercent, boxApp1);
        rigidBody1.getInertiaPose().getTranslation().add(0.01, -0.02, 0.03);
        rootJointDefinition.setSuccessor(rigidBody1);
        RevoluteJointDefinition pinJointDefinition = new RevoluteJointDefinition("pin");
        pinJointDefinition.setAxis((Vector3DReadOnly)Axis3D.Y);
        RigidBodyDefinition rigidBody2 = ExampleExperimentalSimulationTools.newBoxRigidBody("box2", (Tuple3DReadOnly)boxSize2, boxMass2, radiusOfGyrationPercent, boxApp2);
        rigidBody2.setCenterOfMassOffset((Tuple3DReadOnly)connectionOffset);
        VisualDefinitionFactory factory2 = new VisualDefinitionFactory();
        factory2.appendTranslation(0.5 * connectionOffset.getX(), 0.0, 0.0);
        factory2.appendRotation(1.5707963267948966, (Vector3DReadOnly)Axis3D.Y);
        factory2.addCylinder(connectionOffset.getX(), 0.02, new MaterialDefinition(ColorDefinitions.Chocolate()));
        rigidBody2.getVisualDefinitions().forEach(visual -> visual.getOriginPose().prependTranslation((Tuple3DReadOnly)connectionOffset));
        rigidBody2.addVisualDefinitions((Collection)factory2.getVisualDefinitions());
        pinJointDefinition.setSuccessor(rigidBody2);
        rigidBody1.addChildJoint((JointDefinition)pinJointDefinition);
        robotDefinition.setRootBodyDefinition(rootBodyDefinition);
        SixDoFJointState initialRootJointState = new SixDoFJointState(null, (Tuple3DReadOnly)new Point3D(0.0, 0.0, boxSize1.getZ()));
        rootJointDefinition.setInitialJointState(initialRootJointState);
        OneDoFJointState initialPinJointState = new OneDoFJointState();
        initialPinJointState.setEffort(3.0);
        pinJointDefinition.setInitialJointState(initialPinJointState);
        rigidBody1.addCollisionShapeDefinition(new CollisionShapeDefinition((GeometryDefinition)new Box3DDefinition((Tuple3DReadOnly)boxSize1)));
        rigidBody2.addCollisionShapeDefinition(new CollisionShapeDefinition((RigidBodyTransformReadOnly)new RigidBodyTransform((Orientation3DReadOnly)new Quaternion(), (Tuple3DReadOnly)connectionOffset), (GeometryDefinition)new Box3DDefinition((Tuple3DReadOnly)boxSize2)));
        Box3DDefinition terrainGeometry = new Box3DDefinition(groundLength, groundWidth, 0.1);
        RigidBodyTransform terrainPose = new RigidBodyTransform();
        terrainPose.getTranslation().subZ(0.05);
        TerrainObjectDefinition terrain = new TerrainObjectDefinition(new VisualDefinition((RigidBodyTransformReadOnly)terrainPose, (GeometryDefinition)terrainGeometry, new MaterialDefinition(ColorDefinitions.DarkKhaki())), new CollisionShapeDefinition((RigidBodyTransformReadOnly)terrainPose, (GeometryDefinition)terrainGeometry));
        SimulationSession simulationSession = new SimulationSession(BulletPhysicsEngineFactory.newBulletPhysicsEngineFactory());
        simulationSession.addRobot(robotDefinition);
        simulationSession.addTerrainObject(terrain);
        SessionVisualizer.startSessionVisualizer((Session)simulationSession);
    }

    public static void main(String[] args) {
        new ConnectedShapesExperimentalBulletSimulation();
    }
}

