/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.examples.simulations;

import javafx.animation.AnimationTimer;
import javafx.application.Platform;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.stage.Stage;
import us.ihmc.scs2.SimulationConstructionSet2;
import us.ihmc.yoVariables.math.YoMatrix;

public class YoHeatMapGraphic {
    public static void main(String[] args) {
        SimulationConstructionSet2 scs = new SimulationConstructionSet2(SimulationConstructionSet2.doNothingPhysicsEngine());
        YoMatrix matrix = new YoMatrix("matrix", 3, 3, scs.getRootRegistry());
        for (int row = 0; row < matrix.getNumRows(); ++row) {
            for (int column = 0; column < matrix.getNumCols(); ++column) {
                matrix.set(row, column, Math.random());
            }
        }
        scs.start(true, false, false);
        Platform.runLater(() -> {
            Stage window = new Stage();
            window.setTitle("YoHeatMapGraphic");
            HeatMapPane heatMapPane = new HeatMapPane();
            heatMapPane.matrixProperty.setValue((Object)matrix);
            heatMapPane.start();
            window.setScene(new Scene((Parent)heatMapPane, 600.0, 400.0));
            window.setOnCloseRequest(e -> heatMapPane.stop());
            scs.addVisualizerShutdownListener(() -> ((Stage)window).close());
            window.show();
        });
    }

    private static class HeatMapPane
    extends GridPane {
        private StackPane[][] cells;
        private final Property<YoMatrix> matrixProperty = new SimpleObjectProperty((Object)this, "matrix", null);
        private final AnimationTimer animationTimer;

        public HeatMapPane() {
            this.setVgap(2.0);
            this.setHgap(2.0);
            this.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
            this.setStyle("-fx-background-color: grey;");
            this.animationTimer = new AnimationTimer(){

                public void handle(long now) {
                    int column;
                    int row;
                    YoMatrix matrix = (YoMatrix)matrixProperty.getValue();
                    if (matrix == null) {
                        this.getChildren().clear();
                        cells = null;
                        return;
                    }
                    double max = Double.NEGATIVE_INFINITY;
                    double min = Double.POSITIVE_INFINITY;
                    for (row = 0; row < matrix.getNumRows(); ++row) {
                        for (column = 0; column < matrix.getNumCols(); ++column) {
                            double value = matrix.get(row, column);
                            max = Math.max(max, value);
                            min = Math.min(min, value);
                        }
                    }
                    if (cells == null || cells.length != matrix.getNumRows() || cells[0].length != matrix.getNumCols()) {
                        this.getChildren().clear();
                        cells = new StackPane[matrix.getNumRows()][matrix.getNumCols()];
                        for (row = 0; row < matrix.getNumRows(); ++row) {
                            for (column = 0; column < matrix.getNumCols(); ++column) {
                                StackPane cell = new StackPane();
                                cell.setMinSize(1.0, 1.0);
                                cell.setPrefSize(10.0, 10.0);
                                cell.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
                                cells[row][column] = cell;
                                this.add((Node)cell, column, row);
                                GridPane.setHgrow((Node)cell, (Priority)Priority.ALWAYS);
                                GridPane.setVgrow((Node)cell, (Priority)Priority.ALWAYS);
                            }
                        }
                    }
                    for (row = 0; row < matrix.getNumRows(); ++row) {
                        for (column = 0; column < matrix.getNumCols(); ++column) {
                            double value = matrix.get(row, column);
                            double normalizedValue = (value - min) / (max - min);
                            double hue = 240.0 * normalizedValue;
                            cells[row][column].setStyle("-fx-background-color: hsb(" + hue + ", 100%, 100%);");
                        }
                    }
                }
            };
        }

        public void start() {
            this.animationTimer.start();
        }

        public void stop() {
            this.animationTimer.stop();
        }
    }
}

