/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.examples.sessionVisualizer.jfx;

import java.util.Arrays;
import java.util.Collection;
import javafx.beans.value.ObservableValue;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.scene.AmbientLight;
import javafx.scene.Camera;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.PerspectiveCamera;
import javafx.scene.Scene;
import javafx.scene.SceneAntialiasing;
import javafx.scene.paint.Color;
import javafx.scene.paint.Material;
import javafx.scene.paint.Paint;
import javafx.scene.paint.PhongMaterial;
import javafx.scene.shape.Sphere;
import org.fxyz3d.shapes.primitives.Text3DMesh;
import org.fxyz3d.shapes.primitives.TexturedMesh;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.scs2.examples.sessionVisualizer.jfx.ApplicationRunner;
import us.ihmc.scs2.examples.sessionVisualizer.jfx.Text3D;
import us.ihmc.scs2.sessionVisualizer.jfx.Scene3DBuilder;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.camera.PerspectiveCameraController;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.JavaFXMissingTools;

public class Simple3DViewer {
    public static void view3DObjects(Node ... nodesToView) {
        Simple3DViewer.view3DObjects(Arrays.asList(nodesToView));
    }

    public static void view3DObjects(Collection<? extends Node> nodesToView) {
        ApplicationRunner.runApplication(primaryStage -> {
            Scene3DBuilder scene3DBuilder = new Scene3DBuilder();
            Scene scene = new Scene((Parent)scene3DBuilder.getRoot(), 600.0, 400.0, true, SceneAntialiasing.BALANCED);
            scene.setFill((Paint)Color.GREY);
            Simple3DViewer.setupCamera(scene, scene3DBuilder.getRoot());
            scene3DBuilder.addNodesToView((Iterable)nodesToView);
            double ambientValue = 0.2;
            double pointValue = 0.3;
            double pointDistance = 100.0;
            Color ambientColor = Color.color((double)ambientValue, (double)ambientValue, (double)ambientValue);
            scene3DBuilder.addNodeToView((Node)new AmbientLight(ambientColor));
            Color indoorColor = Color.color((double)pointValue, (double)pointValue, (double)pointValue);
            scene3DBuilder.addPointLight(pointDistance, pointDistance, pointDistance, indoorColor);
            scene3DBuilder.addPointLight(-pointDistance, pointDistance, pointDistance, indoorColor);
            scene3DBuilder.addPointLight(-pointDistance, -pointDistance, pointDistance, indoorColor);
            scene3DBuilder.addPointLight(pointDistance, -pointDistance, pointDistance, indoorColor);
            primaryStage.setMaximized(true);
            primaryStage.setScene(scene);
            primaryStage.show();
        });
    }

    public static PerspectiveCameraController setupCamera(Scene scene, Group root) {
        PerspectiveCamera camera = new PerspectiveCamera(true);
        camera.setNearClip(0.05);
        camera.setFarClip(50.0);
        scene.setCamera((Camera)camera);
        PerspectiveCameraController cameraController = new PerspectiveCameraController(scene.widthProperty(), scene.heightProperty(), camera, (Vector3DReadOnly)Axis3D.Z, (Vector3DReadOnly)Axis3D.X);
        cameraController.setCameraPosition(-1.0, -1.0, 1.0);
        cameraController.enableShiftClickFocusTranslation();
        cameraController.start();
        scene.addEventHandler(Event.ANY, (EventHandler)cameraController);
        Sphere focusPointViz = cameraController.getFocalPointViz();
        if (focusPointViz != null) {
            root.getChildren().add((Object)focusPointViz);
            focusPointViz.visibleProperty().bind((ObservableValue)scene.getCamera().focusedProperty());
        }
        return cameraController;
    }

    public static Node createAxisLabels() {
        AxisAngle xAxisAngle = new AxisAngle();
        xAxisAngle.appendYawRotation(-0.7853981633974483);
        xAxisAngle.appendRollRotation(-1.5707963267948966);
        Node xLabel = Simple3DViewer.createLabel("x", Color.RED, 0.1, 0.001, (Point3DReadOnly)new Point3D(300.0, 0.0, 25.0), (Orientation3DReadOnly)xAxisAngle);
        AxisAngle yAxisAngle = new AxisAngle();
        yAxisAngle.appendYawRotation(-0.7853981633974483);
        yAxisAngle.appendRollRotation(-1.5707963267948966);
        Node yLabel = Simple3DViewer.createLabel("y", Color.GREEN, 0.1, 0.001, (Point3DReadOnly)new Point3D(0.0, 300.0, 25.0), (Orientation3DReadOnly)yAxisAngle);
        AxisAngle zAxisAngle = new AxisAngle();
        zAxisAngle.appendYawRotation(-0.7853981633974483);
        zAxisAngle.appendRollRotation(-1.5707963267948966);
        Node zLabel = Simple3DViewer.createLabel("z", Color.BLUE, 0.1, 0.001, (Point3DReadOnly)new Point3D(0.0, 0.0, 325.0), (Orientation3DReadOnly)zAxisAngle);
        return new Group(new Node[]{xLabel, yLabel, zLabel});
    }

    public static Node createLabel(String text, Color color, double height, double thickness, Point3DReadOnly position, Orientation3DReadOnly orientation) {
        Text3D label = new Text3D(text);
        label.setFontHeight(height);
        label.setFontThickness(thickness);
        ((Text3DMesh)label.getNode()).getChildren().forEach(child -> ((TexturedMesh)child).setMaterial((Material)new PhongMaterial(color)));
        label.getNode().getTransforms().add((Object)JavaFXMissingTools.createAffineFromOrientation3DAndTuple((Orientation3DReadOnly)orientation, (Tuple3DReadOnly)position));
        return label.getNode();
    }
}

