/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.examples.simulations;

import us.ihmc.scs2.definition.collision.CollisionShapeDefinition;
import us.ihmc.scs2.definition.geometry.GeometryDefinition;
import us.ihmc.scs2.definition.geometry.Sphere3DDefinition;
import us.ihmc.scs2.definition.robot.JointDefinition;
import us.ihmc.scs2.definition.robot.RigidBodyDefinition;
import us.ihmc.scs2.definition.robot.RobotDefinition;
import us.ihmc.scs2.definition.robot.SixDoFJointDefinition;
import us.ihmc.scs2.definition.visual.ColorDefinitions;
import us.ihmc.scs2.definition.visual.MaterialDefinition;
import us.ihmc.scs2.definition.visual.VisualDefinition;

public class BallRobotDefinition
extends RobotDefinition {
    public BallRobotDefinition() {
        super("Ball");
        RigidBodyDefinition elevator = new RigidBodyDefinition("elevator");
        SixDoFJointDefinition floatingJoint = new SixDoFJointDefinition(this.getRootJointName());
        RigidBodyDefinition ball = this.createBallRigidBody();
        ball.setMass(10.0);
        ball.getMomentOfInertia().setToDiagonal(0.1, 0.1, 0.1);
        this.setRootBodyDefinition(elevator);
        elevator.addChildJoint((JointDefinition)floatingJoint);
        floatingJoint.setSuccessor(ball);
    }

    public String getRootJointName() {
        return "rootJoint";
    }

    private final RigidBodyDefinition createBallRigidBody() {
        RigidBodyDefinition ball = new RigidBodyDefinition("Ball");
        Sphere3DDefinition geometryDefinition = new Sphere3DDefinition(0.3);
        MaterialDefinition materialDefinition = new MaterialDefinition(ColorDefinitions.Red());
        ball.addVisualDefinition(new VisualDefinition((GeometryDefinition)geometryDefinition, materialDefinition));
        ball.addCollisionShapeDefinition(new CollisionShapeDefinition((GeometryDefinition)geometryDefinition));
        return ball;
    }
}

