/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.examples.simulations;

import java.util.Collection;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.mecano.tools.MomentOfInertiaFactory;
import us.ihmc.scs2.definition.robot.JointDefinition;
import us.ihmc.scs2.definition.robot.RigidBodyDefinition;
import us.ihmc.scs2.definition.robot.RobotDefinition;
import us.ihmc.scs2.definition.robot.SixDoFJointDefinition;
import us.ihmc.scs2.definition.visual.ColorDefinition;
import us.ihmc.scs2.definition.visual.MaterialDefinition;
import us.ihmc.scs2.definition.visual.VisualDefinitionFactory;

public class ExampleExperimentalSimulationTools {
    public static RobotDefinition newSphereRobot(String name, double radius, double mass, double radiusOfGyrationPercent, ColorDefinition color, boolean addStripes, ColorDefinition stripesColor) {
        RobotDefinition robotDefinition = new RobotDefinition(name);
        RigidBodyDefinition rootBody = new RigidBodyDefinition(name + "RootBody");
        SixDoFJointDefinition rootJoint = new SixDoFJointDefinition(name);
        rootBody.addChildJoint((JointDefinition)rootJoint);
        rootJoint.setSuccessor(ExampleExperimentalSimulationTools.newSphereRigidBody(name + "RigidBody", radius, mass, radiusOfGyrationPercent, color, addStripes, stripesColor));
        robotDefinition.setRootBodyDefinition(rootBody);
        return robotDefinition;
    }

    public static RigidBodyDefinition newSphereRigidBody(String name, double radius, double mass, double radiusOfGyrationPercent, ColorDefinition color, boolean addStripes, ColorDefinition stripesColor) {
        RigidBodyDefinition rigidBody = new RigidBodyDefinition(name);
        double radiusOfGyration = radiusOfGyrationPercent * radius;
        rigidBody.setMass(mass);
        rigidBody.setMomentOfInertia((Matrix3DReadOnly)MomentOfInertiaFactory.fromMassAndRadiiOfGyration((double)mass, (double)radiusOfGyration, (double)radiusOfGyration, (double)radiusOfGyration));
        VisualDefinitionFactory factory = new VisualDefinitionFactory();
        factory.addSphere(radius, color);
        if (addStripes) {
            double stripePercent = 0.05;
            factory.addArcTorus(0.0, Math.PI * 2, (1.01 - stripePercent) * radius, radius * stripePercent, stripesColor);
            factory.appendRotation(1.5707963267948966, (Vector3DReadOnly)Axis3D.X);
            factory.addArcTorus(0.0, Math.PI * 2, (1.01 - stripePercent) * radius, radius * stripePercent, stripesColor);
        }
        rigidBody.addVisualDefinitions((Collection)factory.getVisualDefinitions());
        return rigidBody;
    }

    public static RobotDefinition newCylinderRobot(String name, double radius, double height, double mass, double radiusOfGyrationPercent, ColorDefinition color, boolean addStripes, ColorDefinition stripesColor) {
        RobotDefinition robotDefinition = new RobotDefinition(name);
        RigidBodyDefinition rootBody = new RigidBodyDefinition(name + "RootBody");
        SixDoFJointDefinition rootJoint = new SixDoFJointDefinition(name);
        rootBody.addChildJoint((JointDefinition)rootJoint);
        RigidBodyDefinition rigidBody = new RigidBodyDefinition(name + "RigidBody");
        rigidBody.setMass(mass);
        rigidBody.setMomentOfInertia((Matrix3DReadOnly)MomentOfInertiaFactory.fromMassAndRadiiOfGyration((double)mass, (double)(radiusOfGyrationPercent * radius), (double)(radiusOfGyrationPercent * radius), (double)(radiusOfGyrationPercent * height)));
        VisualDefinitionFactory factory = new VisualDefinitionFactory();
        factory.addCylinder(height, radius, color);
        if (addStripes) {
            double stripePercent = 0.05;
            factory.appendTranslation(0.0, 0.0, -height * 0.01);
            factory.addBox(2.0 * radius * 1.01, radius * stripePercent, height * 1.02, stripesColor);
            factory.appendRotation(1.5707963267948966, (Vector3DReadOnly)Axis3D.Z);
            factory.addBox(2.0 * radius * 1.01, radius * stripePercent, height * 1.02, stripesColor);
        }
        rigidBody.addVisualDefinitions((Collection)factory.getVisualDefinitions());
        rootJoint.setSuccessor(rigidBody);
        robotDefinition.setRootBodyDefinition(rootBody);
        return robotDefinition;
    }

    public static RobotDefinition newCapsuleRobot(String name, double radius, double height, double mass, double radiusOfGyrationPercent, ColorDefinition color, boolean addStripes, ColorDefinition stripesColor) {
        RobotDefinition robotDefinition = new RobotDefinition(name);
        RigidBodyDefinition rootBody = new RigidBodyDefinition(name + "RootBody");
        SixDoFJointDefinition rootJoint = new SixDoFJointDefinition(name);
        rootBody.addChildJoint((JointDefinition)rootJoint);
        RigidBodyDefinition rigidBody = new RigidBodyDefinition(name + "RigidBody");
        rigidBody.setMass(mass);
        rigidBody.setMomentOfInertia((Matrix3DReadOnly)MomentOfInertiaFactory.fromMassAndRadiiOfGyration((double)mass, (double)(radiusOfGyrationPercent * radius), (double)(radiusOfGyrationPercent * radius), (double)(radiusOfGyrationPercent * height)));
        VisualDefinitionFactory factory = new VisualDefinitionFactory();
        factory.addCapsule(height, radius, color);
        if (addStripes) {
            double stripePercent = 0.05;
            factory.addBox(2.0 * radius * 1.01, radius * stripePercent, height, stripesColor);
            factory.appendRotation(1.5707963267948966, (Vector3DReadOnly)Axis3D.Z);
            factory.addBox(2.0 * radius * 1.01, radius * stripePercent, height, stripesColor);
        }
        rigidBody.addVisualDefinitions((Collection)factory.getVisualDefinitions());
        rootJoint.setSuccessor(rigidBody);
        robotDefinition.setRootBodyDefinition(rootBody);
        return robotDefinition;
    }

    public static RobotDefinition newBoxRobot(String name, Tuple3DReadOnly size, double mass, double radiusOfGyrationPercent, ColorDefinition color) {
        return ExampleExperimentalSimulationTools.newBoxRobot(name, size.getX(), size.getY(), size.getZ(), mass, radiusOfGyrationPercent, color);
    }

    public static RobotDefinition newBoxRobot(String name, double sizeX, double sizeY, double sizeZ, double mass, double radiusOfGyrationPercent, ColorDefinition color) {
        RobotDefinition robotDefinition = new RobotDefinition(name);
        RigidBodyDefinition rootBody = new RigidBodyDefinition(name + "RootBody");
        SixDoFJointDefinition rootJoint = new SixDoFJointDefinition(name);
        rootBody.addChildJoint((JointDefinition)rootJoint);
        rootJoint.setSuccessor(ExampleExperimentalSimulationTools.newBoxRigidBody(name + "RigidBody", sizeX, sizeY, sizeZ, mass, radiusOfGyrationPercent, color));
        robotDefinition.setRootBodyDefinition(rootBody);
        return robotDefinition;
    }

    public static RigidBodyDefinition newBoxRigidBody(String rigidBodyName, Tuple3DReadOnly size, double mass, double radiusOfGyrationPercent, ColorDefinition color) {
        return ExampleExperimentalSimulationTools.newBoxRigidBody(rigidBodyName, size, mass, radiusOfGyrationPercent, null, color);
    }

    public static RigidBodyDefinition newBoxRigidBody(String rigidBodyName, Tuple3DReadOnly size, double mass, double radiusOfGyrationPercent, Vector3DReadOnly offsetFromParent, ColorDefinition color) {
        return ExampleExperimentalSimulationTools.newBoxRigidBody(rigidBodyName, size.getX(), size.getY(), size.getZ(), mass, radiusOfGyrationPercent, offsetFromParent, color);
    }

    public static RigidBodyDefinition newBoxRigidBody(String rigidBodyName, double sizeX, double sizeY, double sizeZ, double mass, double radiusOfGyrationPercent, ColorDefinition color) {
        return ExampleExperimentalSimulationTools.newBoxRigidBody(rigidBodyName, sizeX, sizeY, sizeZ, mass, radiusOfGyrationPercent, null, color);
    }

    public static RigidBodyDefinition newBoxRigidBody(String rigidBodyName, double sizeX, double sizeY, double sizeZ, double mass, double radiusOfGyrationPercent, Vector3DReadOnly offsetFromParentJoint, ColorDefinition color) {
        RigidBodyDefinition rigidBody = new RigidBodyDefinition(rigidBodyName);
        rigidBody.setMass(mass);
        rigidBody.setMomentOfInertia((Matrix3DReadOnly)MomentOfInertiaFactory.fromMassAndRadiiOfGyration((double)mass, (double)(radiusOfGyrationPercent * sizeX), (double)(radiusOfGyrationPercent * sizeY), (double)(radiusOfGyrationPercent * sizeZ)));
        if (offsetFromParentJoint != null) {
            rigidBody.setCenterOfMassOffset((Tuple3DReadOnly)offsetFromParentJoint);
        }
        VisualDefinitionFactory factory = new VisualDefinitionFactory();
        if (offsetFromParentJoint != null) {
            factory.appendTranslation((Tuple3DReadOnly)offsetFromParentJoint);
        }
        factory.addBox(sizeX, sizeY, sizeZ, new MaterialDefinition(color));
        rigidBody.addVisualDefinitions((Collection)factory.getVisualDefinitions());
        return rigidBody;
    }
}

