/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.examples.simulations;

import us.ihmc.euclid.geometry.Pose3D;
import us.ihmc.euclid.geometry.interfaces.Pose3DReadOnly;
import us.ihmc.scs2.SimulationConstructionSet2;
import us.ihmc.scs2.definition.robot.JointDefinition;
import us.ihmc.scs2.definition.robot.RobotDefinition;
import us.ihmc.scs2.definition.state.SixDoFJointState;
import us.ihmc.scs2.definition.state.interfaces.JointStateReadOnly;
import us.ihmc.scs2.definition.terrain.TerrainObjectDefinition;
import us.ihmc.scs2.definition.yoSlider.YoSliderDefinition;
import us.ihmc.scs2.definition.yoSlider.YoSliderboardDefinition;
import us.ihmc.scs2.examples.simulations.BoxRobotDefinition;
import us.ihmc.scs2.examples.simulations.SlopeGroundDefinition;

public class SliderboardExampleSimulation {
    public static void main(String[] args) {
        BoxRobotDefinition definition = new BoxRobotDefinition();
        SixDoFJointState initialJointState = new SixDoFJointState();
        initialJointState.setConfiguration((Pose3DReadOnly)new Pose3D(0.0, 0.0, 1.0, 0.0, 0.0, 0.0));
        ((JointDefinition)definition.getRootJointDefinitions().get(0)).setInitialJointState((JointStateReadOnly)initialJointState);
        SimulationConstructionSet2 scs = new SimulationConstructionSet2(SimulationConstructionSet2.impulseBasedPhysicsEngineFactory());
        scs.addRobot((RobotDefinition)definition);
        scs.addTerrainObject((TerrainObjectDefinition)new SlopeGroundDefinition());
        scs.clearAllSliderboards();
        scs.setSliderboard(SliderboardExampleSimulation.createSliderboard());
        scs.setSliderboardButton("AnotherSliderboard", 0, "is_rootJoint_pinned");
        scs.setDefaultSliderboardKnob(0, "qd_rootJoint_wZ");
        scs.start(true, false, false);
    }

    private static YoSliderboardDefinition createSliderboard() {
        YoSliderboardDefinition sliderboard = new YoSliderboardDefinition("Default");
        sliderboard.getSliders().add(new YoSliderDefinition("q_rootJoint_yaw", -1, -Math.PI, Math.PI));
        sliderboard.getSliders().add(new YoSliderDefinition("q_rootJoint_pitch", -1, -1.5707963267948966, 1.5707963267948966));
        sliderboard.getSliders().add(new YoSliderDefinition("q_rootJoint_roll", -1, -Math.PI, Math.PI));
        sliderboard.getSliders().add(new YoSliderDefinition("root.gravityZ", -1, -10.0, 10.0));
        return sliderboard;
    }
}

