/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.examples.simulations.bullet;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;
import us.ihmc.commons.RandomNumbers;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.yawPitchRoll.YawPitchRoll;
import us.ihmc.mecano.tools.MomentOfInertiaFactory;
import us.ihmc.scs2.definition.YawPitchRollTransformDefinition;
import us.ihmc.scs2.definition.collision.CollisionShapeDefinition;
import us.ihmc.scs2.definition.geometry.Box3DDefinition;
import us.ihmc.scs2.definition.geometry.GeometryDefinition;
import us.ihmc.scs2.definition.robot.JointDefinition;
import us.ihmc.scs2.definition.robot.RigidBodyDefinition;
import us.ihmc.scs2.definition.robot.RobotDefinition;
import us.ihmc.scs2.definition.robot.SixDoFJointDefinition;
import us.ihmc.scs2.definition.state.SixDoFJointState;
import us.ihmc.scs2.definition.state.interfaces.JointStateReadOnly;
import us.ihmc.scs2.definition.terrain.TerrainObjectDefinition;
import us.ihmc.scs2.definition.visual.ColorDefinition;
import us.ihmc.scs2.definition.visual.ColorDefinitions;
import us.ihmc.scs2.definition.visual.MaterialDefinition;
import us.ihmc.scs2.definition.visual.VisualDefinition;
import us.ihmc.scs2.definition.visual.VisualDefinitionFactory;
import us.ihmc.scs2.session.Session;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizer;
import us.ihmc.scs2.simulation.SimulationSession;
import us.ihmc.scs2.simulation.bullet.physicsEngine.BulletPhysicsEngineFactory;

public class StackOfBoxesExperimentalBulletSimulation {
    private static final boolean VISUALIZE_WITH_DEBUG_DRAWING = false;

    public StackOfBoxesExperimentalBulletSimulation() {
        double groundWidth = 5.0;
        double groundLength = 5.0;
        int numberOfBlocks = 6;
        Random random = new Random(1886L);
        ArrayList<RobotDefinition> robotDefinitions = new ArrayList<RobotDefinition>();
        double radiusOfGyrationPercent = 0.5;
        double boxSizeX = 0.1;
        double boxSizeY = 0.08;
        double boxSizeZ = 0.1;
        double mass = 0.2;
        double intertiaPoseX = 0.09;
        double intertiaPoseY = 0.03;
        double intertiaPoseZ = 0.01;
        double intertiaPoseYaw = 0.01;
        double intertiaPosePitch = 0.03;
        double intertiaPoseRoll = 0.05;
        YawPitchRollTransformDefinition inertiaPose = new YawPitchRollTransformDefinition(intertiaPoseX, intertiaPoseY, intertiaPoseZ, intertiaPoseYaw, intertiaPosePitch, intertiaPoseRoll);
        for (int i = 0; i < numberOfBlocks; ++i) {
            ColorDefinition appearance = ColorDefinition.rgb((int)random.nextInt());
            String name = "Block" + i;
            RobotDefinition boxRobot = new RobotDefinition(name);
            RigidBodyDefinition rootBody = new RigidBodyDefinition(name + "RootBody");
            SixDoFJointDefinition rootJoint = new SixDoFJointDefinition(name);
            rootBody.addChildJoint((JointDefinition)rootJoint);
            RigidBodyDefinition rigidBody = new RigidBodyDefinition(name + "RigidBody");
            rigidBody.setMass(mass);
            rigidBody.setMomentOfInertia((Matrix3DReadOnly)MomentOfInertiaFactory.fromMassAndRadiiOfGyration((double)mass, (double)(radiusOfGyrationPercent * boxSizeX), (double)(radiusOfGyrationPercent * boxSizeY), (double)(radiusOfGyrationPercent * boxSizeZ)));
            rigidBody.getInertiaPose().set((RigidBodyTransformReadOnly)inertiaPose);
            VisualDefinitionFactory factory = new VisualDefinitionFactory();
            factory.appendTransform((RigidBodyTransformReadOnly)inertiaPose);
            factory.addBox(boxSizeX, boxSizeY, boxSizeZ, new MaterialDefinition(appearance));
            rigidBody.addVisualDefinitions((Collection)factory.getVisualDefinitions());
            rootJoint.setSuccessor(rigidBody);
            boxRobot.setRootBodyDefinition(rootBody);
            robotDefinitions.add(boxRobot);
            CollisionShapeDefinition collisionShapeDefinition = new CollisionShapeDefinition((GeometryDefinition)new Box3DDefinition(boxSizeX, boxSizeY, boxSizeZ));
            collisionShapeDefinition.getOriginPose().set((RigidBodyTransformReadOnly)inertiaPose);
            boxRobot.getRigidBodyDefinition(name + "RigidBody").addCollisionShapeDefinition(collisionShapeDefinition);
            double x = 0.0;
            double y = (double)i * 0.02;
            double z = boxSizeZ * 2.1 * ((double)i + 1.0);
            double yaw = 0.0;
            double pitch = RandomNumbers.nextDouble((Random)random, (double)(-Math.PI / 90), (double)(Math.PI / 90));
            double roll = RandomNumbers.nextDouble((Random)random, (double)(-Math.PI / 90), (double)(Math.PI / 90));
            ((JointDefinition)boxRobot.getRootJointDefinitions().get(0)).setInitialJointState((JointStateReadOnly)new SixDoFJointState((Orientation3DReadOnly)new YawPitchRoll(yaw, pitch, roll), (Tuple3DReadOnly)new Point3D(x, y, z)));
        }
        Box3DDefinition terrainGeometry = new Box3DDefinition(groundLength, groundWidth, 0.1);
        RigidBodyTransform terrainPose = new RigidBodyTransform();
        terrainPose.getTranslation().subZ(0.05);
        TerrainObjectDefinition terrain = new TerrainObjectDefinition(new VisualDefinition((RigidBodyTransformReadOnly)terrainPose, (GeometryDefinition)terrainGeometry, new MaterialDefinition(ColorDefinitions.DarkKhaki())), new CollisionShapeDefinition((RigidBodyTransformReadOnly)terrainPose, (GeometryDefinition)terrainGeometry));
        SimulationSession simulationSession = new SimulationSession(BulletPhysicsEngineFactory.newBulletPhysicsEngineFactory());
        simulationSession.addTerrainObject(terrain);
        robotDefinitions.forEach(arg_0 -> ((SimulationSession)simulationSession).addRobot(arg_0));
        SessionVisualizer.startSessionVisualizer((Session)simulationSession);
    }

    public static void main(String[] args) {
        new StackOfBoxesExperimentalBulletSimulation();
    }
}

