/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.examples.simulations.bullet;

import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.yawPitchRoll.YawPitchRoll;
import us.ihmc.scs2.definition.collision.CollisionShapeDefinition;
import us.ihmc.scs2.definition.geometry.Box3DDefinition;
import us.ihmc.scs2.definition.geometry.GeometryDefinition;
import us.ihmc.scs2.definition.robot.JointDefinition;
import us.ihmc.scs2.definition.robot.RobotDefinition;
import us.ihmc.scs2.definition.state.SixDoFJointState;
import us.ihmc.scs2.definition.state.interfaces.JointStateReadOnly;
import us.ihmc.scs2.definition.terrain.TerrainObjectDefinition;
import us.ihmc.scs2.definition.visual.ColorDefinitions;
import us.ihmc.scs2.definition.visual.MaterialDefinition;
import us.ihmc.scs2.definition.visual.VisualDefinition;
import us.ihmc.scs2.examples.simulations.ExampleExperimentalSimulationTools;
import us.ihmc.scs2.examples.simulations.bullet.BulletExampleSimulationTools;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizer;
import us.ihmc.scs2.simulation.SimulationSession;
import us.ihmc.scs2.simulation.bullet.physicsEngine.BulletPhysicsEngine;

public class SingleBoxBulletSimulation {
    public SingleBoxBulletSimulation() {
        double boxXLength = 0.2;
        double boxYWidth = 0.12;
        double boxZHeight = 0.4;
        double boxMass = 1.0;
        double boxRadiusOfGyrationPercent = 0.8;
        double initialBoxRoll = -0.04908738521234052;
        double initialVelocity = 0.0;
        double groundWidth = 1.0;
        double groundLength = 1.0;
        SimulationSession simulationSession = new SimulationSession((frame, rootRegistry) -> new BulletPhysicsEngine(frame, rootRegistry));
        RobotDefinition boxRobot = ExampleExperimentalSimulationTools.newBoxRobot("box", boxXLength, boxYWidth, boxZHeight, boxMass, boxRadiusOfGyrationPercent, ColorDefinitions.DarkCyan());
        ((JointDefinition)boxRobot.getRootJointDefinitions().get(0)).getSuccessor().getInertiaPose().getTranslation().set(-0.002, 0.0, 0.0);
        RigidBodyTransform boxRobotTransform = new RigidBodyTransform((Orientation3DReadOnly)new YawPitchRoll(0.0, 0.0, initialBoxRoll), (Tuple3DReadOnly)new Point3D(0.0, 0.5, 0.3));
        boxRobot.getRigidBodyDefinition("boxRigidBody").addCollisionShapeDefinition(new CollisionShapeDefinition((GeometryDefinition)new Box3DDefinition(boxXLength, boxYWidth, boxZHeight)));
        SixDoFJointState initialJointState = new SixDoFJointState((Orientation3DReadOnly)boxRobotTransform.getRotation(), (Tuple3DReadOnly)boxRobotTransform.getTranslation());
        initialJointState.setVelocity(null, (Vector3DReadOnly)new Vector3D(initialVelocity, 0.0, 0.0));
        ((JointDefinition)boxRobot.getRootJointDefinitions().get(0)).setInitialJointState((JointStateReadOnly)initialJointState);
        simulationSession.addRobot(boxRobot);
        Box3DDefinition terrainGeometry = new Box3DDefinition(groundLength, groundWidth, 0.1);
        RigidBodyTransform terrainPose = new RigidBodyTransform((Orientation3DReadOnly)new Quaternion(), (Tuple3DReadOnly)new Vector3D(0.0, 0.0, -0.05));
        TerrainObjectDefinition terrain = new TerrainObjectDefinition(new VisualDefinition((RigidBodyTransformReadOnly)terrainPose, (GeometryDefinition)terrainGeometry, new MaterialDefinition(ColorDefinitions.DarkKhaki())), new CollisionShapeDefinition((RigidBodyTransformReadOnly)terrainPose, (GeometryDefinition)terrainGeometry));
        simulationSession.addTerrainObject(terrain);
        SessionVisualizer sessionVisualizer = BulletExampleSimulationTools.startSessionVisualizerWithDebugDrawing(simulationSession);
        sessionVisualizer.getToolkit().getSession().runTick();
    }

    public static void main(String[] args) {
        new SingleBoxBulletSimulation();
    }
}

