/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.examples.simulations;

import java.util.Collection;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.yawPitchRoll.YawPitchRoll;
import us.ihmc.mecano.tools.MomentOfInertiaFactory;
import us.ihmc.scs2.definition.collision.CollisionShapeDefinition;
import us.ihmc.scs2.definition.geometry.Box3DDefinition;
import us.ihmc.scs2.definition.geometry.Cylinder3DDefinition;
import us.ihmc.scs2.definition.geometry.GeometryDefinition;
import us.ihmc.scs2.definition.robot.JointDefinition;
import us.ihmc.scs2.definition.robot.RigidBodyDefinition;
import us.ihmc.scs2.definition.robot.RobotDefinition;
import us.ihmc.scs2.definition.robot.SixDoFJointDefinition;
import us.ihmc.scs2.definition.state.SixDoFJointState;
import us.ihmc.scs2.definition.terrain.TerrainObjectDefinition;
import us.ihmc.scs2.definition.visual.ColorDefinitions;
import us.ihmc.scs2.definition.visual.MaterialDefinition;
import us.ihmc.scs2.definition.visual.VisualDefinition;
import us.ihmc.scs2.definition.visual.VisualDefinitionFactory;
import us.ihmc.scs2.session.Session;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizer;
import us.ihmc.scs2.simulation.SimulationSession;
import us.ihmc.scs2.simulation.parameters.ContactParameters;
import us.ihmc.scs2.simulation.physicsEngine.PhysicsEngineFactory;

public class SpinningCoinExperimentalSimulation {
    private static final String SPINNING_COIN = "SpinningCoin";
    private final double coinWidth = 0.00175;
    private final double coinRadius = 0.01213;
    private final double coinMass = 0.00567;
    private final double spinningAngularVelocity = Math.PI * 2;

    public SpinningCoinExperimentalSimulation() {
        ContactParameters contactParameters = new ContactParameters();
        contactParameters.setMinimumPenetration(5.0E-5);
        contactParameters.setCoefficientOfFriction(0.7);
        contactParameters.setCoefficientOfRestitution(0.0);
        contactParameters.setRestitutionThreshold(0.0);
        contactParameters.setErrorReductionParameter(0.001);
        RobotDefinition robotDefinition = new RobotDefinition(SPINNING_COIN);
        RigidBodyDefinition rootBody = new RigidBodyDefinition("rootBody");
        robotDefinition.setRootBodyDefinition(rootBody);
        SixDoFJointDefinition rootJoint = new SixDoFJointDefinition("rootJoint");
        rootBody.addChildJoint((JointDefinition)rootJoint);
        RigidBodyDefinition coinBody = new RigidBodyDefinition("coin");
        rootJoint.setSuccessor(coinBody);
        coinBody.setMass(0.00567);
        coinBody.setMomentOfInertia((Matrix3DReadOnly)MomentOfInertiaFactory.fromMassAndRadiiOfGyration((double)0.00567, (double)0.006065, (double)0.006065, (double)8.75E-4));
        VisualDefinitionFactory factory = new VisualDefinitionFactory();
        factory.appendTranslation(0.0, 0.0, -8.75E-4);
        factory.addCylinder(0.00175, 0.01213, ColorDefinitions.Purple());
        factory.identity();
        factory.appendTranslation(0.0, 0.0, 8.75E-4);
        factory.addBox(0.004043333333333334, 0.004043333333333334, 4.375E-4, ColorDefinitions.AliceBlue());
        factory.appendTranslation(0.0, 0.0, -0.0021875);
        factory.addBox(0.004043333333333334, 0.004043333333333334, 4.375E-4, ColorDefinitions.Gold());
        coinBody.addVisualDefinitions((Collection)factory.getVisualDefinitions());
        coinBody.addCollisionShapeDefinition(new CollisionShapeDefinition((GeometryDefinition)new Cylinder3DDefinition(0.00175, 0.01213)));
        SixDoFJointState initialJointState = new SixDoFJointState();
        initialJointState.setConfiguration((Orientation3DReadOnly)new YawPitchRoll(0.0, 0.0, 1.2), (Tuple3DReadOnly)new Point3D(0.1, 0.1, 0.05213));
        initialJointState.setVelocity((Vector3DReadOnly)new Vector3D(0.0, Math.PI * 2, 0.0), null);
        rootJoint.setInitialJointState(initialJointState);
        RigidBodyTransform terrainPose = new RigidBodyTransform();
        terrainPose.getTranslation().subZ(0.05);
        Box3DDefinition terrainGeometry = new Box3DDefinition(1000.0, 1000.0, 0.1);
        TerrainObjectDefinition terrain = new TerrainObjectDefinition(new VisualDefinition((RigidBodyTransformReadOnly)terrainPose, (GeometryDefinition)terrainGeometry, new MaterialDefinition(ColorDefinitions.DarkGrey())), new CollisionShapeDefinition((RigidBodyTransformReadOnly)terrainPose, (GeometryDefinition)terrainGeometry));
        SimulationSession simulationSession = new SimulationSession(PhysicsEngineFactory.newImpulseBasedPhysicsEngineFactory((ContactParameters)contactParameters));
        simulationSession.addRobot(robotDefinition);
        simulationSession.addTerrainObject(terrain);
        SessionVisualizer.startSessionVisualizer((Session)simulationSession);
    }

    public static void main(String[] args) {
        new SpinningCoinExperimentalSimulation();
    }
}

