/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.examples.simulations;

import java.util.ArrayList;
import us.ihmc.euclid.geometry.interfaces.Pose3DReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.FloatingJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.MultiBodySystemBasics;
import us.ihmc.mecano.spatial.SpatialVector;
import us.ihmc.mecano.spatial.interfaces.SpatialVectorReadOnly;
import us.ihmc.scs2.definition.collision.CollisionShapeDefinition;
import us.ihmc.scs2.definition.controller.ControllerInput;
import us.ihmc.scs2.definition.controller.ControllerOutput;
import us.ihmc.scs2.definition.controller.interfaces.Controller;
import us.ihmc.scs2.definition.geometry.Box3DDefinition;
import us.ihmc.scs2.definition.geometry.GeometryDefinition;
import us.ihmc.scs2.definition.robot.JointDefinition;
import us.ihmc.scs2.definition.robot.RobotDefinition;
import us.ihmc.scs2.definition.state.SixDoFJointState;
import us.ihmc.scs2.definition.state.interfaces.JointStateReadOnly;
import us.ihmc.scs2.definition.terrain.TerrainObjectDefinition;
import us.ihmc.scs2.definition.visual.ColorDefinitions;
import us.ihmc.scs2.examples.simulations.ExampleExperimentalSimulationTools;
import us.ihmc.scs2.session.Session;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizer;
import us.ihmc.scs2.simulation.SimulationSession;
import us.ihmc.scs2.simulation.parameters.ContactParameters;
import us.ihmc.scs2.simulation.physicsEngine.PhysicsEngineFactory;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoseUsingYawPitchRoll;
import us.ihmc.yoVariables.registry.YoRegistry;

public class BridgeOfBoxesSimulation {
    private static final String BRIDGE_NAME = "Bridge";
    private static final String RIGHT_SUPPORT = "RightSupport";
    private static final String LEFT_SUPPORT = "LeftSupport";
    private static final boolean SUPPORT_STATIC = false;

    public BridgeOfBoxesSimulation() {
        ContactParameters contactParameters = new ContactParameters();
        contactParameters.setMinimumPenetration(5.0E-5);
        contactParameters.setCoefficientOfFriction(0.7);
        contactParameters.setCoefficientOfRestitution(0.0);
        contactParameters.setRestitutionThreshold(0.0);
        contactParameters.setErrorReductionParameter(0.1);
        ArrayList<RobotDefinition> robots = new ArrayList<RobotDefinition>();
        Vector3D bridgeSize = new Vector3D(3.0, 0.3, 0.2);
        double bridgeMass = 5.0;
        Vector3D supportSize = new Vector3D(0.5, 0.5, 0.5);
        double supportMass = 5.0;
        RobotDefinition bridgeRobot = ExampleExperimentalSimulationTools.newBoxRobot(BRIDGE_NAME, (Tuple3DReadOnly)bridgeSize, bridgeMass, 0.8, ColorDefinitions.Aquamarine());
        robots.add(bridgeRobot);
        double bridgeHeight = 1.0;
        SixDoFJointState initialJointState = new SixDoFJointState(null, (Tuple3DReadOnly)new Point3D(0.0, 0.0, bridgeHeight + 0.5 * bridgeSize.getZ() - 5.0E-4));
        ((JointDefinition)bridgeRobot.getRootJointDefinitions().get(0)).setInitialJointState((JointStateReadOnly)initialJointState);
        bridgeRobot.getRigidBodyDefinition("BridgeRigidBody").addCollisionShapeDefinition(new CollisionShapeDefinition((GeometryDefinition)new Box3DDefinition((Tuple3DReadOnly)bridgeSize)));
        YoRegistry registry = new YoRegistry("controllerInputs");
        YoFramePoseUsingYawPitchRoll leftSupportPose = this.createSupportPose(true, registry, (Tuple3DReadOnly)bridgeSize, bridgeHeight, (Tuple3DReadOnly)supportSize);
        YoFramePoseUsingYawPitchRoll rightSupportPose = this.createSupportPose(false, registry, (Tuple3DReadOnly)bridgeSize, bridgeHeight, (Tuple3DReadOnly)supportSize);
        TerrainObjectDefinition terrainObjectDefinition = new TerrainObjectDefinition();
        String supportName = LEFT_SUPPORT;
        RobotDefinition leftSupportRobot = ExampleExperimentalSimulationTools.newBoxRobot(supportName, (Tuple3DReadOnly)supportSize, supportMass, 0.8, ColorDefinitions.Crimson());
        ((JointDefinition)leftSupportRobot.getRootJointDefinitions().get(0)).setInitialJointState((JointStateReadOnly)new SixDoFJointState((Orientation3DReadOnly)leftSupportPose.getOrientation(), (Tuple3DReadOnly)leftSupportPose.getPosition()));
        leftSupportRobot.getRigidBodyDefinition(supportName + "RigidBody").addCollisionShapeDefinition(new CollisionShapeDefinition((GeometryDefinition)new Box3DDefinition((Tuple3DReadOnly)supportSize)));
        robots.add(leftSupportRobot);
        supportName = RIGHT_SUPPORT;
        RobotDefinition rightSupportRobot = ExampleExperimentalSimulationTools.newBoxRobot(supportName, (Tuple3DReadOnly)supportSize, supportMass, 0.8, ColorDefinitions.Crimson());
        ((JointDefinition)rightSupportRobot.getRootJointDefinitions().get(0)).setInitialJointState((JointStateReadOnly)new SixDoFJointState((Orientation3DReadOnly)rightSupportPose.getOrientation(), (Tuple3DReadOnly)rightSupportPose.getPosition()));
        rightSupportRobot.getRigidBodyDefinition(supportName + "RigidBody").addCollisionShapeDefinition(new CollisionShapeDefinition((GeometryDefinition)new Box3DDefinition((Tuple3DReadOnly)supportSize)));
        robots.add(rightSupportRobot);
        leftSupportRobot.addControllerDefinition((in, out) -> this.newSupportController(true, (Pose3DReadOnly)leftSupportPose, in, out, supportMass, bridgeMass));
        rightSupportRobot.addControllerDefinition((in, out) -> this.newSupportController(false, (Pose3DReadOnly)rightSupportPose, in, out, supportMass, bridgeMass));
        SimulationSession simulationSession = new SimulationSession(PhysicsEngineFactory.newImpulseBasedPhysicsEngineFactory((ContactParameters)contactParameters));
        robots.forEach(arg_0 -> ((SimulationSession)simulationSession).addRobot(arg_0));
        simulationSession.addTerrainObject(terrainObjectDefinition);
        SessionVisualizer.startSessionVisualizer((Session)simulationSession);
    }

    private YoFramePoseUsingYawPitchRoll createSupportPose(boolean leftSide, YoRegistry registry, Tuple3DReadOnly bridgeSize, double bridgeHeight, Tuple3DReadOnly supportSize) {
        String prefix = leftSide ? "left" : "right";
        YoFramePoseUsingYawPitchRoll pose = new YoFramePoseUsingYawPitchRoll(prefix + "SupportPose", ReferenceFrame.getWorldFrame(), registry);
        double sign = leftSide ? -1.0 : 1.0;
        pose.setPitch(sign * Math.toRadians(45.0));
        pose.getPosition().set(sign * (0.3 * bridgeSize.getX()), 0.0, bridgeHeight);
        pose.appendTranslation(0.5 * sign * supportSize.getX(), 0.0, -0.5 * supportSize.getZ());
        return pose;
    }

    private Controller newSupportController(boolean leftSide, Pose3DReadOnly desiredSupportPose, ControllerInput controllerInput, ControllerOutput controllerOutput, double supportMass, double bridgeMass) {
        MultiBodySystemBasics controllerRobot = controllerInput.createCopy(ReferenceFrame.getWorldFrame());
        FloatingJointBasics joint = (FloatingJointBasics)controllerRobot.getJointsToConsider().get(0);
        double kp = 1000.0;
        double kd = 200.0;
        double frequency = 1.0;
        double amplitude = 0.2;
        SpatialVector proportionalTerm = new SpatialVector();
        SpatialVector derivativeTerm = new SpatialVector();
        SpatialVector gravityTerm = new SpatialVector();
        FramePose3D errorPose = new FramePose3D();
        return () -> {
            controllerInput.readState(controllerRobot);
            controllerRobot.getRootBody().updateFramesRecursively();
            errorPose.setIncludingFrame(ReferenceFrame.getWorldFrame(), desiredSupportPose);
            double offset = amplitude * Math.sin(Math.PI * 2 * frequency * controllerInput.getTime());
            errorPose.getPosition().addX(leftSide ? -offset : offset);
            errorPose.changeFrame((ReferenceFrame)joint.getFrameAfterJoint());
            proportionalTerm.setToZero((ReferenceFrame)joint.getFrameAfterJoint());
            proportionalTerm.getLinearPart().set((FrameTuple3DReadOnly)errorPose.getPosition());
            errorPose.getOrientation().getRotationVector(proportionalTerm.getAngularPart());
            proportionalTerm.scale(kp);
            derivativeTerm.setIncludingFrame((SpatialVectorReadOnly)joint.getJointTwist());
            derivativeTerm.scale(-kd);
            gravityTerm.setToZero(ReferenceFrame.getWorldFrame());
            gravityTerm.setLinearPartZ(9.81 * (supportMass + 0.5 * bridgeMass));
            gravityTerm.changeFrame((ReferenceFrame)joint.getFrameAfterJoint());
            joint.getJointWrench().set((SpatialVectorReadOnly)proportionalTerm);
            joint.getJointWrench().add((SpatialVectorReadOnly)derivativeTerm);
            joint.getJointWrench().add((SpatialVectorReadOnly)gravityTerm);
            controllerOutput.getJointOutput((JointReadOnly)joint).setEffort((JointReadOnly)joint);
        };
    }

    public static void main(String[] args) {
        new BridgeOfBoxesSimulation();
    }
}

