/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.definition.yoSlider;

import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import us.ihmc.scs2.definition.configuration.WindowConfigurationDefinition;
import us.ihmc.scs2.definition.yoSlider.YoSliderboardDefinition;

@XmlRootElement(name="YoSliderboardList")
public class YoSliderboardListDefinition {
    private String name;
    private List<YoSliderboardDefinition> yoSliderboards = new ArrayList<YoSliderboardDefinition>();
    private WindowConfigurationDefinition windowConfiguration;

    public YoSliderboardListDefinition() {
    }

    public YoSliderboardListDefinition(String name, YoSliderboardDefinition yoSliderboard) {
        this(null, Collections.singletonList(yoSliderboard));
    }

    public YoSliderboardListDefinition(String name, List<YoSliderboardDefinition> yoSliderboards) {
        this.name = name;
        this.yoSliderboards = yoSliderboards;
    }

    public YoSliderboardListDefinition(YoSliderboardListDefinition other) {
        this.set(other);
    }

    public void set(YoSliderboardListDefinition other) {
        this.name = other.name;
        this.yoSliderboards = other.yoSliderboards != null ? other.yoSliderboards.stream().map(YoSliderboardDefinition::new).collect(Collectors.toList()) : null;
        this.windowConfiguration = other.windowConfiguration != null ? new WindowConfigurationDefinition(other.windowConfiguration) : null;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setYoSliderboards(List<YoSliderboardDefinition> yoSliderboards) {
        this.yoSliderboards = yoSliderboards;
    }

    public void setWindowConfiguration(WindowConfigurationDefinition windowConfiguration) {
        this.windowConfiguration = windowConfiguration;
    }

    public String getName() {
        return this.name;
    }

    public List<YoSliderboardDefinition> getYoSliderboards() {
        return this.yoSliderboards;
    }

    public WindowConfigurationDefinition getWindowConfiguration() {
        return this.windowConfiguration;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof YoSliderboardListDefinition) {
            YoSliderboardListDefinition other = (YoSliderboardListDefinition)object;
            if (!Objects.equals(this.name, other.name)) {
                return false;
            }
            if (!Objects.equals(this.yoSliderboards, other.yoSliderboards)) {
                return false;
            }
            return Objects.equals(this.windowConfiguration, other.windowConfiguration);
        }
        return false;
    }

    public String toString() {
        return "name:" + this.name + ", yoSliderboards:" + this.yoSliderboards + ", windowConfiguration:" + this.windowConfiguration;
    }
}

