/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.definition.yoGraphic;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.List;
import java.util.Objects;
import us.ihmc.scs2.definition.yoComposite.YoTuple3DDefinition;
import us.ihmc.scs2.definition.yoGraphic.YoGraphic3DDefinition;

@XmlRootElement(name="YoGraphicPointcloud3D")
public class YoGraphicPointcloud3DDefinition
extends YoGraphic3DDefinition {
    private List<YoTuple3DDefinition> points;
    private String numberOfPoints;
    private String size;
    private String graphicName;

    public YoGraphicPointcloud3DDefinition() {
    }

    public YoGraphicPointcloud3DDefinition(YoGraphicPointcloud3DDefinition other) {
        super(other);
        this.points = other.points != null ? other.points.stream().map(YoTuple3DDefinition::copy).toList() : null;
        this.numberOfPoints = other.numberOfPoints;
        this.size = other.size;
        this.graphicName = other.graphicName;
    }

    @Override
    protected void registerFields() {
        super.registerFields();
        this.registerListField("points", this::getPoints, this::setPoints, "p", Object::toString, YoTuple3DDefinition::parse);
        this.registerStringField("numberOfPoints", this::getNumberOfPoints, this::setNumberOfPoints);
        this.registerStringField("size", this::getSize, this::setSize);
        this.registerStringField("graphicName", this::getGraphicName, this::setGraphicName);
    }

    @XmlElement
    public void setPoints(List<YoTuple3DDefinition> points) {
        this.points = points;
    }

    @XmlElement
    public void setNumberOfPoints(String numberOfPoints) {
        this.numberOfPoints = numberOfPoints;
    }

    public void setSize(double size) {
        this.setSize(Double.toString(size));
    }

    @XmlElement
    public void setSize(String size) {
        this.size = size;
    }

    @XmlElement
    public void setGraphicName(String graphicName) {
        this.graphicName = graphicName;
    }

    public List<YoTuple3DDefinition> getPoints() {
        return this.points;
    }

    public String getNumberOfPoints() {
        return this.numberOfPoints;
    }

    public String getSize() {
        return this.size;
    }

    public String getGraphicName() {
        return this.graphicName;
    }

    @Override
    public YoGraphicPointcloud3DDefinition copy() {
        return new YoGraphicPointcloud3DDefinition(this);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (object instanceof YoGraphicPointcloud3DDefinition) {
            YoGraphicPointcloud3DDefinition other = (YoGraphicPointcloud3DDefinition)object;
            if (!Objects.equals(this.points, other.points)) {
                return false;
            }
            if (!Objects.equals(this.numberOfPoints, other.numberOfPoints)) {
                return false;
            }
            if (!Objects.equals(this.size, other.size)) {
                return false;
            }
            return Objects.equals(this.graphicName, other.graphicName);
        }
        return false;
    }

    @Override
    public String toString(int indent) {
        String out = "%s [name=%s, visible=%b, color=%s, points=%s, numberOfPoints=%s, size=%s, graphicName=%s]";
        return out.formatted(this.getClass().getSimpleName(), this.name, this.visible, this.color, YoGraphicPointcloud3DDefinition.indentedListString(indent, true, this.points, Object::toString), this.numberOfPoints, this.size, this.graphicName);
    }
}

