/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.definition.robot.sdf.items;

import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import java.util.Collections;
import java.util.List;
import us.ihmc.scs2.definition.robot.sdf.items.SDFItem;
import us.ihmc.scs2.definition.robot.sdf.items.SDFURIHolder;

public class SDFJoint
implements SDFItem {
    private String name;
    private String type;
    private String child;
    private String parent;
    private String pose;
    private String threadPitch;
    private SDFAxis axis;
    private SDFAxis axis2;

    @XmlAttribute(name="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @XmlAttribute(name="type")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getParent() {
        return this.parent;
    }

    @XmlElement(name="parent")
    public void setParent(String parent) {
        this.parent = parent;
    }

    public String getPose() {
        return this.pose;
    }

    @XmlElement(name="pose")
    public void setPose(String pose) {
        this.pose = pose;
    }

    public String getThreadPitch() {
        return this.threadPitch;
    }

    @XmlElement(name="thread_pitch")
    public void setThreadPitch(String threadPitch) {
        this.threadPitch = threadPitch;
    }

    public SDFAxis getAxis() {
        return this.axis;
    }

    @XmlElement(name="axis")
    public void setAxis(SDFAxis axis) {
        this.axis = axis;
    }

    public SDFAxis getAxis2() {
        return this.axis2;
    }

    @XmlElement(name="axis2")
    public void setAxis2(SDFAxis axis2) {
        this.axis2 = axis2;
    }

    public String getChild() {
        return this.child;
    }

    @XmlElement(name="child")
    public void setChild(String child) {
        this.child = child;
    }

    @Override
    public String getContentAsString() {
        return this.format("[name: %s, type: %s, child: %s, parent: %s, pose: %s, threadPitch: %s, axis: %s, axis2: %s]", this.name, this.type, this.child, this.parent, this.pose, this.threadPitch, this.axis, this.axis2);
    }

    public List<SDFURIHolder> getURIHolders() {
        return SDFItem.combineItemURIHolders(this.axis, this.axis2);
    }

    public String toString() {
        return this.itemToString();
    }

    public static class SDFAxis
    implements SDFItem {
        private String xyz;
        private SDFDynamics dynamics;
        private SDFLimit limit;

        public String getXYZ() {
            return this.xyz;
        }

        @XmlElement(name="xyz")
        public void setXYZ(String xyz) {
            this.xyz = xyz;
        }

        public SDFDynamics getDynamics() {
            return this.dynamics;
        }

        @XmlElement(name="dynamics")
        public void setDynamics(SDFDynamics dynamics) {
            this.dynamics = dynamics;
        }

        public SDFLimit getLimit() {
            return this.limit;
        }

        @XmlElement(name="limit")
        public void setLimit(SDFLimit limit) {
            this.limit = limit;
        }

        @Override
        public String getContentAsString() {
            return this.format("[xyz: %s, dynamics: %s, limit]", this.xyz, this.dynamics, this.limit);
        }

        public List<SDFURIHolder> getURIHolders() {
            return SDFItem.combineItemURIHolders(this.dynamics, this.limit);
        }

        public String toString() {
            return this.itemToString();
        }

        public static class SDFDynamics
        implements SDFItem {
            private String damping;
            private String friction;

            public String getDamping() {
                return this.damping;
            }

            @XmlElement(name="damping")
            public void setDamping(String damping) {
                this.damping = damping;
            }

            public String getFriction() {
                return this.friction;
            }

            @XmlElement(name="friction")
            public void setFriction(String friction) {
                this.friction = friction;
            }

            @Override
            public String getContentAsString() {
                return this.format("[damping: %s, friction: %s]", this.damping, this.friction);
            }

            public List<SDFURIHolder> getURIHolders() {
                return Collections.emptyList();
            }

            public String toString() {
                return this.itemToString();
            }
        }

        public static class SDFLimit
        implements SDFItem {
            private String lower;
            private String upper;
            private String effort;
            private String velocity;

            public String getLower() {
                return this.lower;
            }

            @XmlElement(name="lower")
            public void setLower(String lower) {
                this.lower = lower;
            }

            public String getUpper() {
                return this.upper;
            }

            @XmlElement(name="upper")
            public void setUpper(String upper) {
                this.upper = upper;
            }

            public String getEffort() {
                return this.effort;
            }

            @XmlElement(name="effort")
            public void setEffort(String effort) {
                this.effort = effort;
            }

            public String getVelocity() {
                return this.velocity;
            }

            @XmlElement(name="velocity")
            public void setVelocity(String velocity) {
                this.velocity = velocity;
            }

            @Override
            public String getContentAsString() {
                return this.format("[lower: %s, upper: %s, effort: %s, velocity: %s]", this.lower, this.upper, this.effort, this.velocity);
            }

            public List<SDFURIHolder> getURIHolders() {
                return Collections.emptyList();
            }

            public String toString() {
                return this.itemToString();
            }
        }
    }
}

