/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.definition.robot;

import jakarta.xml.bind.annotation.XmlElement;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.scs2.definition.robot.SensorDefinition;

public class LidarSensorDefinition
extends SensorDefinition {
    private double sweepYawMin;
    private double sweepYawMax;
    private double heightPitchMin;
    private double heightPitchMax;
    private double minRange;
    private double maxRange;
    private double rangeResolution;
    private int pointsPerSweep;
    private int scanHeight;
    private double gaussianNoiseMean;
    private double gaussianNoiseStandardDeviation;

    public LidarSensorDefinition() {
    }

    public LidarSensorDefinition(String name, RigidBodyTransformReadOnly transformToJoint) {
        super(name, transformToJoint);
    }

    public LidarSensorDefinition(LidarSensorDefinition other) {
        super(other);
        this.sweepYawMin = other.sweepYawMin;
        this.sweepYawMax = other.sweepYawMax;
        this.heightPitchMin = other.heightPitchMin;
        this.heightPitchMax = other.heightPitchMax;
        this.minRange = other.minRange;
        this.maxRange = other.maxRange;
        this.rangeResolution = other.rangeResolution;
        this.pointsPerSweep = other.pointsPerSweep;
        this.scanHeight = other.scanHeight;
        this.gaussianNoiseMean = other.gaussianNoiseMean;
        this.gaussianNoiseStandardDeviation = other.gaussianNoiseStandardDeviation;
    }

    public double getSweepYawMin() {
        return this.sweepYawMin;
    }

    public double getSweepYawMax() {
        return this.sweepYawMax;
    }

    public double getHeightPitchMin() {
        return this.heightPitchMin;
    }

    public double getHeightPitchMax() {
        return this.heightPitchMax;
    }

    public double getMinRange() {
        return this.minRange;
    }

    public double getMaxRange() {
        return this.maxRange;
    }

    public double getRangeResolution() {
        return this.rangeResolution;
    }

    public int getPointsPerSweep() {
        return this.pointsPerSweep;
    }

    public int getScanHeight() {
        return this.scanHeight;
    }

    public double getGaussianNoiseMean() {
        return this.gaussianNoiseMean;
    }

    public double getGaussianNoiseStandardDeviation() {
        return this.gaussianNoiseStandardDeviation;
    }

    public void setSweepYawLimits(double min, double max) {
        this.sweepYawMin = min;
        this.sweepYawMax = max;
    }

    @XmlElement
    public void setSweepYawMin(double sweepYawMin) {
        this.sweepYawMin = sweepYawMin;
    }

    @XmlElement
    public void setSweepYawMax(double sweepYawMax) {
        this.sweepYawMax = sweepYawMax;
    }

    public void setHeightPitchLimits(double min, double max) {
        this.heightPitchMin = min;
        this.heightPitchMax = max;
    }

    @XmlElement
    public void setHeightPitchMin(double heightPitchMin) {
        this.heightPitchMin = heightPitchMin;
    }

    @XmlElement
    public void setHeightPitchMax(double heightPitchMax) {
        this.heightPitchMax = heightPitchMax;
    }

    public void setRangeLimits(double min, double max) {
        this.minRange = min;
        this.maxRange = max;
    }

    @XmlElement
    public void setMinRange(double minRange) {
        this.minRange = minRange;
    }

    @XmlElement
    public void setMaxRange(double maxRange) {
        this.maxRange = maxRange;
    }

    @XmlElement
    public void setRangeResolution(double rangeResolution) {
        this.rangeResolution = rangeResolution;
    }

    @XmlElement
    public void setPointsPerSweep(int pointsPerSweep) {
        this.pointsPerSweep = pointsPerSweep;
    }

    @XmlElement
    public void setScanHeight(int scanHeight) {
        this.scanHeight = scanHeight;
    }

    @XmlElement
    public void setGaussianNoiseMean(double gaussianNoiseMean) {
        this.gaussianNoiseMean = gaussianNoiseMean;
    }

    @XmlElement
    public void setGaussianNoiseStandardDeviation(double gaussianNoiseStandardDeviation) {
        this.gaussianNoiseStandardDeviation = gaussianNoiseStandardDeviation;
    }

    @Override
    public LidarSensorDefinition copy() {
        return new LidarSensorDefinition(this);
    }

    @Override
    public int hashCode() {
        long bits = super.hashCode();
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (double)this.sweepYawMin);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (double)this.sweepYawMax);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (double)this.heightPitchMin);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (double)this.heightPitchMax);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (double)this.minRange);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (double)this.maxRange);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (double)this.rangeResolution);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (int)this.pointsPerSweep);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (int)this.scanHeight);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (double)this.gaussianNoiseMean);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (double)this.gaussianNoiseStandardDeviation);
        return EuclidHashCodeTools.toIntHashCode((long)bits);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        LidarSensorDefinition other = (LidarSensorDefinition)object;
        if (!EuclidCoreTools.equals((double)this.sweepYawMin, (double)other.sweepYawMin)) {
            return false;
        }
        if (!EuclidCoreTools.equals((double)this.sweepYawMax, (double)other.sweepYawMax)) {
            return false;
        }
        if (!EuclidCoreTools.equals((double)this.heightPitchMin, (double)other.heightPitchMin)) {
            return false;
        }
        if (!EuclidCoreTools.equals((double)this.heightPitchMax, (double)other.heightPitchMax)) {
            return false;
        }
        if (!EuclidCoreTools.equals((double)this.minRange, (double)other.minRange)) {
            return false;
        }
        if (!EuclidCoreTools.equals((double)this.maxRange, (double)other.maxRange)) {
            return false;
        }
        if (!EuclidCoreTools.equals((double)this.rangeResolution, (double)other.rangeResolution)) {
            return false;
        }
        if (this.pointsPerSweep != other.pointsPerSweep) {
            return false;
        }
        if (this.scanHeight != other.scanHeight) {
            return false;
        }
        if (!EuclidCoreTools.equals((double)this.gaussianNoiseMean, (double)other.gaussianNoiseMean)) {
            return false;
        }
        return EuclidCoreTools.equals((double)this.gaussianNoiseStandardDeviation, (double)other.gaussianNoiseStandardDeviation);
    }
}

