/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.definition.geometry;

import jakarta.xml.bind.annotation.XmlElement;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.scs2.definition.geometry.GeometryDefinition;

public class TruncatedCone3DDefinition
extends GeometryDefinition {
    private double height;
    private double topRadiusX;
    private double topRadiusY;
    private double baseRadiusX;
    private double baseRadiusY;
    private boolean centered = false;
    private int resolution = 64;

    public TruncatedCone3DDefinition() {
        this.setName("truncatedCone");
    }

    public TruncatedCone3DDefinition(double height, double topRadius, double baseRadius) {
        this(height, topRadius, topRadius, baseRadius, baseRadius);
    }

    public TruncatedCone3DDefinition(double height, double topRadius, double baseRadius, boolean centered) {
        this(height, topRadius, topRadius, baseRadius, baseRadius, centered);
    }

    public TruncatedCone3DDefinition(double height, double topRadius, double baseRadius, int resolution) {
        this(height, topRadius, topRadius, baseRadius, baseRadius, resolution);
    }

    public TruncatedCone3DDefinition(double height, double topRadius, double baseRadius, boolean centered, int resolution) {
        this(height, topRadius, topRadius, baseRadius, baseRadius, centered, resolution);
    }

    public TruncatedCone3DDefinition(double height, double topRadiusX, double topRadiusY, double baseRadiusX, double baseRadiusY) {
        this();
        this.height = height;
        this.topRadiusX = topRadiusX;
        this.topRadiusY = topRadiusY;
        this.baseRadiusX = baseRadiusX;
        this.baseRadiusY = baseRadiusY;
    }

    public TruncatedCone3DDefinition(double height, double topRadiusX, double topRadiusY, double baseRadiusX, double baseRadiusY, boolean centered) {
        this();
        this.height = height;
        this.topRadiusX = topRadiusX;
        this.topRadiusY = topRadiusY;
        this.baseRadiusX = baseRadiusX;
        this.baseRadiusY = baseRadiusY;
        this.centered = centered;
    }

    public TruncatedCone3DDefinition(double height, double topRadiusX, double topRadiusY, double baseRadiusX, double baseRadiusY, int resolution) {
        this();
        this.height = height;
        this.topRadiusX = topRadiusX;
        this.topRadiusY = topRadiusY;
        this.baseRadiusX = baseRadiusX;
        this.baseRadiusY = baseRadiusY;
        this.resolution = resolution;
    }

    public TruncatedCone3DDefinition(double height, double topRadiusX, double topRadiusY, double baseRadiusX, double baseRadiusY, boolean centered, int resolution) {
        this();
        this.height = height;
        this.topRadiusX = topRadiusX;
        this.topRadiusY = topRadiusY;
        this.baseRadiusX = baseRadiusX;
        this.baseRadiusY = baseRadiusY;
        this.centered = centered;
        this.resolution = resolution;
    }

    public TruncatedCone3DDefinition(TruncatedCone3DDefinition other) {
        this.setName(other.getName());
        this.height = other.height;
        this.topRadiusX = other.topRadiusX;
        this.topRadiusY = other.topRadiusY;
        this.baseRadiusX = other.baseRadiusX;
        this.baseRadiusY = other.baseRadiusY;
        this.centered = other.centered;
        this.resolution = other.resolution;
    }

    @XmlElement
    public void setHeight(double height) {
        this.height = height;
    }

    @XmlElement
    public void setTopRadiusX(double topRadiusX) {
        this.topRadiusX = topRadiusX;
    }

    @XmlElement
    public void setTopRadiusY(double topRadiusY) {
        this.topRadiusY = topRadiusY;
    }

    public void setTopRadius(double topRadius) {
        this.setTopRadii(topRadius, topRadius);
    }

    public void setTopRadii(double topRadiusX, double topRadiusY) {
        this.topRadiusX = topRadiusX;
        this.topRadiusY = topRadiusY;
    }

    @XmlElement
    public void setBaseRadiusX(double baseRadiusX) {
        this.baseRadiusX = baseRadiusX;
    }

    @XmlElement
    public void setBaseRadiusY(double baseRadiusY) {
        this.baseRadiusY = baseRadiusY;
    }

    public void setBaseRadius(double baseRadius) {
        this.setBaseRadii(baseRadius, baseRadius);
    }

    public void setBaseRadii(double baseRadiusX, double baseRadiusY) {
        this.baseRadiusX = baseRadiusX;
        this.baseRadiusY = baseRadiusY;
    }

    @XmlElement
    public void setCentered(boolean centered) {
        this.centered = centered;
    }

    @XmlElement
    public void setResolution(int resolution) {
        this.resolution = resolution;
    }

    public double getHeight() {
        return this.height;
    }

    public double getTopRadiusX() {
        return this.topRadiusX;
    }

    public double getTopRadiusY() {
        return this.topRadiusY;
    }

    public double getBaseRadiusX() {
        return this.baseRadiusX;
    }

    public double getBaseRadiusY() {
        return this.baseRadiusY;
    }

    public boolean getCentered() {
        return this.centered;
    }

    public int getResolution() {
        return this.resolution;
    }

    @Override
    public TruncatedCone3DDefinition copy() {
        return new TruncatedCone3DDefinition(this);
    }

    @Override
    public int hashCode() {
        long bits = super.hashCode();
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (double)this.height);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (double)this.topRadiusX);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (double)this.topRadiusY);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (double)this.baseRadiusX);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (double)this.baseRadiusY);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (boolean)this.centered);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (int)this.resolution);
        return EuclidHashCodeTools.toIntHashCode((long)bits);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        TruncatedCone3DDefinition other = (TruncatedCone3DDefinition)object;
        if (!EuclidCoreTools.equals((double)this.height, (double)other.height)) {
            return false;
        }
        if (!EuclidCoreTools.equals((double)this.topRadiusX, (double)other.topRadiusX)) {
            return false;
        }
        if (!EuclidCoreTools.equals((double)this.topRadiusY, (double)other.topRadiusY)) {
            return false;
        }
        if (!EuclidCoreTools.equals((double)this.baseRadiusX, (double)other.baseRadiusX)) {
            return false;
        }
        if (!EuclidCoreTools.equals((double)this.baseRadiusY, (double)other.baseRadiusY)) {
            return false;
        }
        if (this.centered != other.centered) {
            return false;
        }
        return this.resolution == other.resolution;
    }

    public String toString() {
        return "Truncated Cone: [name: " + this.getName() + ", height: " + String.format(EuclidCoreIOTools.DEFAULT_FORMAT, this.height) + EuclidCoreIOTools.getStringOf((String)", top radii: (", (String)")", (String)", ", (double[])new double[]{this.topRadiusX, this.topRadiusY}) + EuclidCoreIOTools.getStringOf((String)", base radii: (", (String)")", (String)", ", (double[])new double[]{this.baseRadiusX, this.baseRadiusY}) + ", resolution: " + this.resolution + "]";
    }
}

