/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.definition.geometry;

import jakarta.xml.bind.annotation.XmlElement;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.scs2.definition.geometry.Capsule3DDefinition;

public class STPCapsule3DDefinition
extends Capsule3DDefinition {
    private double minimumMargin;
    private double maximumMargin;

    public STPCapsule3DDefinition() {
    }

    public STPCapsule3DDefinition(Capsule3DDefinition other) {
        super(other);
    }

    public STPCapsule3DDefinition(STPCapsule3DDefinition other) {
        super(other);
        this.setMargins(other.minimumMargin, other.maximumMargin);
    }

    public STPCapsule3DDefinition(double length, double radiusX, double radiusY, double radiusZ, int resolution) {
        super(length, radiusX, radiusY, radiusZ, resolution);
    }

    public STPCapsule3DDefinition(double length, double radiusX, double radiusY, double radiusZ) {
        super(length, radiusX, radiusY, radiusZ);
    }

    public STPCapsule3DDefinition(double length, double radius, int resolution) {
        super(length, radius, resolution);
    }

    public STPCapsule3DDefinition(double length, double radius) {
        super(length, radius);
    }

    public void setMargins(double minimumMargin, double maximumMargin) {
        this.setMinimumMargin(minimumMargin);
        this.setMaximumMargin(maximumMargin);
    }

    @XmlElement
    public void setMinimumMargin(double minimumMargin) {
        this.minimumMargin = minimumMargin;
    }

    @XmlElement
    public void setMaximumMargin(double maximumMargin) {
        this.maximumMargin = maximumMargin;
    }

    public double getMinimumMargin() {
        return this.minimumMargin;
    }

    public double getMaximumMargin() {
        return this.maximumMargin;
    }

    @Override
    public STPCapsule3DDefinition copy() {
        return new STPCapsule3DDefinition(this);
    }

    @Override
    public int hashCode() {
        long bits = super.hashCode();
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (double)this.minimumMargin);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (double)this.maximumMargin);
        return EuclidHashCodeTools.toIntHashCode((long)bits);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        STPCapsule3DDefinition other = (STPCapsule3DDefinition)object;
        if (!EuclidCoreTools.equals((double)this.minimumMargin, (double)other.minimumMargin)) {
            return false;
        }
        return EuclidCoreTools.equals((double)this.maximumMargin, (double)other.maximumMargin);
    }

    @Override
    public String toString() {
        return "STP" + super.toString().replace("]", "") + EuclidCoreIOTools.getStringOf((String)", margins: (", (String)")]", (String)", ", (double[])new double[]{this.minimumMargin, this.maximumMargin});
    }
}

