/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.definition.geometry;

import jakarta.xml.bind.annotation.XmlAttribute;
import java.util.Objects;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.scs2.definition.geometry.GeometryDefinition;

public class Point2DDefinition
extends GeometryDefinition
implements Point2DBasics {
    private final Point2D position = new Point2D();

    public Point2DDefinition() {
    }

    public Point2DDefinition(Tuple2DReadOnly position) {
        this.position.set(position);
    }

    public Point2DDefinition(Point2DDefinition other) {
        this.setName(other.getName());
        this.position.set(other.position);
    }

    public Point2D getPosition() {
        return this.position;
    }

    @XmlAttribute
    public void setX(double x) {
        this.position.setX(x);
    }

    @XmlAttribute
    public void setY(double y) {
        this.position.setY(y);
    }

    public double getX() {
        return this.position.getX();
    }

    public double getY() {
        return this.position.getY();
    }

    @Override
    public int hashCode() {
        long bits = super.hashCode();
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (Object)this.position);
        return EuclidHashCodeTools.toIntHashCode((long)bits);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        Point2DDefinition other = (Point2DDefinition)object;
        return Objects.equals(this.position, other.position);
    }

    @Override
    public Point2DDefinition copy() {
        return new Point2DDefinition(this);
    }
}

