/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.definition.geometry;

import jakarta.xml.bind.annotation.XmlElement;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Stream;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.euclid.tuple2D.Point2D32;
import us.ihmc.euclid.tuple3D.Point3D32;
import us.ihmc.euclid.tuple3D.Vector3D32;
import us.ihmc.scs2.definition.geometry.GeometryDefinition;

public class TriangleMesh3DDefinition
extends GeometryDefinition {
    private Point3D32[] vertices;
    private Point2D32[] textures;
    private Vector3D32[] normals;
    private int[] triangleIndices;

    public TriangleMesh3DDefinition() {
        this.setName("TriangleMesh");
    }

    public TriangleMesh3DDefinition(Point3D32[] vertices, Point2D32[] textures, Vector3D32[] normals, int[] triangleIndices) {
        this();
        this.setVertices(vertices);
        this.setTextures(textures);
        this.setNormals(normals);
        this.setTriangleIndices(triangleIndices);
    }

    public TriangleMesh3DDefinition(String name, Point3D32[] vertices, Point2D32[] textures, Vector3D32[] normals, int[] triangleIndices) {
        this.setName(name);
        this.setVertices(vertices);
        this.setTextures(textures);
        this.setNormals(normals);
        this.setTriangleIndices(triangleIndices);
    }

    public TriangleMesh3DDefinition(TriangleMesh3DDefinition other) {
        this.setName(other.getName());
        this.vertices = other.vertices == null ? null : (Point3D32[])Stream.of(other.vertices).map(Point3D32::new).toArray(Point3D32[]::new);
        this.textures = other.textures == null ? null : (Point2D32[])Stream.of(other.textures).map(Point2D32::new).toArray(Point2D32[]::new);
        this.normals = other.normals == null ? null : (Vector3D32[])Stream.of(other.normals).map(Vector3D32::new).toArray(Vector3D32[]::new);
        this.triangleIndices = other.triangleIndices == null ? null : Arrays.copyOf(other.triangleIndices, other.triangleIndices.length);
    }

    @XmlElement
    public void setVertices(Point3D32[] vertices) {
        this.vertices = vertices;
    }

    @XmlElement
    public void setTextures(Point2D32[] textures) {
        this.textures = textures;
    }

    @XmlElement
    public void setNormals(Vector3D32[] normals) {
        this.normals = normals;
    }

    @XmlElement
    public void setTriangleIndices(int[] triangleIndices) {
        this.triangleIndices = triangleIndices;
    }

    public Point3D32[] getVertices() {
        return this.vertices;
    }

    public Point2D32[] getTextures() {
        return this.textures;
    }

    public Vector3D32[] getNormals() {
        return this.normals;
    }

    public int[] getTriangleIndices() {
        return this.triangleIndices;
    }

    @Override
    public TriangleMesh3DDefinition copy() {
        return new TriangleMesh3DDefinition(this);
    }

    @Override
    public int hashCode() {
        long bits = super.hashCode();
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (Object[])this.vertices);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (Object[])this.textures);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (Object[])this.normals);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (int[])this.triangleIndices);
        return EuclidHashCodeTools.toIntHashCode((long)bits);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        TriangleMesh3DDefinition other = (TriangleMesh3DDefinition)object;
        if (!Objects.equals(this.getName(), other.getName())) {
            return false;
        }
        if (!Arrays.equals(this.vertices, other.vertices)) {
            return false;
        }
        if (!Arrays.equals(this.textures, other.textures)) {
            return false;
        }
        if (!Arrays.equals(this.normals, other.normals)) {
            return false;
        }
        if (!Arrays.equals(this.triangleIndices, other.triangleIndices)) {
            return false;
        }
        return super.equals(object);
    }
}

