/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.definition.geometry;

import jakarta.xml.bind.annotation.XmlElement;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.scs2.definition.geometry.GeometryDefinition;

public class Cone3DDefinition
extends GeometryDefinition {
    private double height;
    private double radius;
    private int resolution = 64;

    public Cone3DDefinition() {
        this.setName("cone");
    }

    public Cone3DDefinition(double height, double radius) {
        this();
        this.height = height;
        this.radius = radius;
    }

    public Cone3DDefinition(double height, double radius, int resolution) {
        this();
        this.height = height;
        this.radius = radius;
        this.resolution = resolution;
    }

    public Cone3DDefinition(Cone3DDefinition other) {
        this.setName(other.getName());
        this.height = other.height;
        this.radius = other.radius;
        this.resolution = other.resolution;
    }

    @XmlElement
    public void setHeight(double height) {
        this.height = height;
    }

    @XmlElement
    public void setRadius(double radius) {
        this.radius = radius;
    }

    @XmlElement
    public void setResolution(int resolution) {
        this.resolution = resolution;
    }

    public double getHeight() {
        return this.height;
    }

    public double getRadius() {
        return this.radius;
    }

    public int getResolution() {
        return this.resolution;
    }

    @Override
    public Cone3DDefinition copy() {
        return new Cone3DDefinition(this);
    }

    @Override
    public int hashCode() {
        long bits = super.hashCode();
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (double)this.height);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (double)this.radius);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (int)this.resolution);
        return EuclidHashCodeTools.toIntHashCode((long)bits);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        Cone3DDefinition other = (Cone3DDefinition)object;
        if (!EuclidCoreTools.equals((double)this.height, (double)other.height)) {
            return false;
        }
        if (!EuclidCoreTools.equals((double)this.radius, (double)other.radius)) {
            return false;
        }
        return this.resolution == other.resolution;
    }

    public String toString() {
        return "Cone: [name: " + this.getName() + ", height: " + String.format(EuclidCoreIOTools.DEFAULT_FORMAT, this.height) + ", radius: " + String.format(EuclidCoreIOTools.DEFAULT_FORMAT, this.radius) + ", resolution: " + this.resolution + "]";
    }
}

