/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.definition.yoGraphic;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.XmlRootElement;
import us.ihmc.scs2.definition.robot.RobotDefinition;
import us.ihmc.scs2.definition.yoComposite.YoOrientation3DDefinition;
import us.ihmc.scs2.definition.yoComposite.YoTuple3DDefinition;
import us.ihmc.scs2.definition.yoGraphic.YoGraphic3DDefinition;

@XmlRootElement(name="YoGraphicRobotDefinition")
public class YoGraphicRobotDefinition
extends YoGraphic3DDefinition {
    private RobotDefinition robotDefinition;
    private YoRobotStateDefinition robotStateDefinition;

    public YoGraphicRobotDefinition() {
    }

    public YoGraphicRobotDefinition(YoGraphicRobotDefinition other) {
        if (other.name != null) {
            this.setName(other.name);
        }
        if (other.color != null) {
            this.setColor(other.color);
        }
        if (other.robotDefinition != null) {
            this.setRobotDefinition(new RobotDefinition(other.robotDefinition));
        }
        if (other.robotStateDefinition != null) {
            this.setRobotStateDefinition(new YoRobotStateDefinition(other.robotStateDefinition));
        }
    }

    public YoGraphicRobotDefinition(RobotDefinition robotDefinition) {
        this.setRobotDefinition(robotDefinition);
    }

    public void setRobotDefinition(RobotDefinition robotDefinition) {
        this.robotDefinition = robotDefinition;
    }

    public void setRobotStateDefinition(YoRobotStateDefinition robotStateDefinition) {
        this.robotStateDefinition = robotStateDefinition;
    }

    public RobotDefinition getRobotDefinition() {
        return this.robotDefinition;
    }

    public YoRobotStateDefinition getRobotStateDefinition() {
        return this.robotStateDefinition;
    }

    @Override
    public YoGraphicRobotDefinition copy() {
        return new YoGraphicRobotDefinition(this);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (object instanceof YoGraphicRobotDefinition) {
            YoGraphicRobotDefinition other = (YoGraphicRobotDefinition)object;
            if (!Objects.equals(this.robotDefinition, other.robotDefinition)) {
                return false;
            }
            return Objects.equals(this.robotStateDefinition, other.robotStateDefinition);
        }
        return false;
    }

    public static class YoRobotStateDefinition {
        private YoTuple3DDefinition rootJointPosition;
        private YoOrientation3DDefinition rootJointOrientation;
        private List<YoOneDoFJointStateDefinition> jointPositions;

        public YoRobotStateDefinition() {
        }

        public YoRobotStateDefinition(YoRobotStateDefinition other) {
            if (other == null) {
                return;
            }
            if (other.rootJointPosition != null) {
                this.setRootJointPosition(other.rootJointPosition.copy());
            }
            if (other.rootJointOrientation != null) {
                this.setRootJointOrientation(other.rootJointOrientation.copy());
            }
            if (other.jointPositions != null) {
                this.jointPositions = other.jointPositions.stream().map(YoOneDoFJointStateDefinition::new).collect(Collectors.toList());
            }
        }

        public void setRootJointPosition(YoTuple3DDefinition rootJointPosition) {
            this.rootJointPosition = rootJointPosition;
        }

        public void setRootJointOrientation(YoOrientation3DDefinition rootJointOrientation) {
            this.rootJointOrientation = rootJointOrientation;
        }

        public void setJointPositions(List<YoOneDoFJointStateDefinition> jointPositions) {
            this.jointPositions = jointPositions;
        }

        public YoTuple3DDefinition getRootJointPosition() {
            return this.rootJointPosition;
        }

        public YoOrientation3DDefinition getRootJointOrientation() {
            return this.rootJointOrientation;
        }

        public List<YoOneDoFJointStateDefinition> getJointPositions() {
            return this.jointPositions;
        }

        public YoRobotStateDefinition copy() {
            YoRobotStateDefinition copy = new YoRobotStateDefinition();
            copy.rootJointPosition = this.rootJointPosition != null ? this.rootJointPosition.copy() : null;
            copy.rootJointOrientation = this.rootJointOrientation != null ? this.rootJointOrientation.copy() : null;
            copy.jointPositions = this.jointPositions != null ? this.jointPositions.stream().map(YoOneDoFJointStateDefinition::copy).toList() : null;
            return copy;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof YoRobotStateDefinition) {
                YoRobotStateDefinition other = (YoRobotStateDefinition)object;
                if (!Objects.equals(this.rootJointPosition, other.rootJointPosition)) {
                    return false;
                }
                if (!Objects.equals(this.rootJointOrientation, other.rootJointOrientation)) {
                    return false;
                }
                return Objects.equals(this.jointPositions, other.jointPositions);
            }
            return false;
        }
    }

    public static class YoOneDoFJointStateDefinition {
        private String jointName;
        private String jointPosition;

        public YoOneDoFJointStateDefinition() {
        }

        public YoOneDoFJointStateDefinition(String jointName, String jointPosition) {
            this.setJointName(jointName);
            this.setJointPosition(jointPosition);
        }

        public YoOneDoFJointStateDefinition(YoOneDoFJointStateDefinition other) {
            this.setJointName(other.jointName);
            this.setJointPosition(other.jointPosition);
        }

        public void setJointName(String jointName) {
            this.jointName = jointName;
        }

        public void setJointPosition(String jointPosition) {
            this.jointPosition = jointPosition;
        }

        public String getJointName() {
            return this.jointName;
        }

        public String getJointPosition() {
            return this.jointPosition;
        }

        public YoOneDoFJointStateDefinition copy() {
            YoOneDoFJointStateDefinition copy = new YoOneDoFJointStateDefinition();
            copy.jointName = this.jointName;
            copy.jointPosition = this.jointPosition;
            return copy;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof YoOneDoFJointStateDefinition) {
                YoOneDoFJointStateDefinition other = (YoOneDoFJointStateDefinition)object;
                if (!Objects.equals(this.jointName, other.jointName)) {
                    return false;
                }
                return Objects.equals(this.jointPosition, other.jointPosition);
            }
            return false;
        }
    }
}

